/*
 * Decompiled with CFR 0.152.
 */
package com.example.lootbag;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="bountybags", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BountyBagsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue LEGENDARY_CHANCE;
    public static final ForgeConfigSpec.DoubleValue EPIC_CHANCE;
    public static final ForgeConfigSpec.DoubleValue SUPER_RARE_CHANCE;
    public static final ForgeConfigSpec.DoubleValue RARE_CHANCE;
    public static final ForgeConfigSpec.DoubleValue BOSS_LEGENDARY_CHANCE;
    public static final ForgeConfigSpec.DoubleValue BOSS_EPIC_CHANCE;
    public static final ForgeConfigSpec.DoubleValue NETHER_LEGENDARY_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue NETHER_EPIC_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue NETHER_SUPER_RARE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ALLOWED_MOB_TYPES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BOSS_MOB_TYPES;
    public static final ForgeConfigSpec.DoubleValue ZOMBIE_DROP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue SKELETON_DROP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue CREEPER_DROP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue SPIDER_DROP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue ENDERMAN_DROP_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DROPS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_NETHER_BONUS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BOSS_SPECIAL_RATES;
    public static final ForgeConfigSpec.BooleanValue USE_CUSTOM_LOOT;
    public static final ForgeConfigSpec.BooleanValue USE_ALL_AGGRESSIVE_MOBS;
    public static final ForgeConfigSpec.IntValue RARE_MIN_ITEMS;
    public static final ForgeConfigSpec.IntValue RARE_MAX_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> RARE_LOOT_ITEMS;
    public static final ForgeConfigSpec.IntValue SUPER_RARE_MIN_ITEMS;
    public static final ForgeConfigSpec.IntValue SUPER_RARE_MAX_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SUPER_RARE_LOOT_ITEMS;
    public static final ForgeConfigSpec.IntValue EPIC_MIN_ITEMS;
    public static final ForgeConfigSpec.IntValue EPIC_MAX_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EPIC_LOOT_ITEMS;
    public static final ForgeConfigSpec.IntValue LEGENDARY_MIN_ITEMS;
    public static final ForgeConfigSpec.IntValue LEGENDARY_MAX_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LEGENDARY_LOOT_ITEMS;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        LOGGER.info("Bounty Bags config loaded/reloaded");
    }

    static {
        BUILDER.comment("Bounty Bags Configuration").push("general");
        ENABLE_DROPS = BUILDER.comment("Whether bounty bags should drop from mobs at all").define("enableDrops", true);
        ENABLE_NETHER_BONUS = BUILDER.comment("Whether mobs in the Nether should have increased drop rates").define("enableNetherBonus", true);
        ENABLE_BOSS_SPECIAL_RATES = BUILDER.comment("Whether boss mobs should use special drop rates").define("enableBossSpecialRates", true);
        USE_CUSTOM_LOOT = BUILDER.comment("Whether to use custom loot configuration instead of loot table JSON files").define("useCustomLoot", false);
        USE_ALL_AGGRESSIVE_MOBS = BUILDER.comment("Whether to allow ALL aggressive/hostile mobs to drop bounty bags (ignores allowedMobTypes list)").define("useAllAggressiveMobs", true);
        BUILDER.pop();
        BUILDER.comment("Drop chances for regular mobs (0.0 = 0%, 1.0 = 100%)").push("regular_mob_drops");
        LEGENDARY_CHANCE = BUILDER.comment("Base chance for legendary bounty bag drops from regular mobs").defineInRange("legendaryChance", 0.01, 0.0, 1.0);
        EPIC_CHANCE = BUILDER.comment("Base chance for epic bounty bag drops from regular mobs").defineInRange("epicChance", 0.02, 0.0, 1.0);
        SUPER_RARE_CHANCE = BUILDER.comment("Base chance for super rare bounty bag drops from regular mobs").defineInRange("superRareChance", 0.04, 0.0, 1.0);
        RARE_CHANCE = BUILDER.comment("Base chance for rare bounty bag drops from regular mobs").defineInRange("rareChance", 0.15, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment("Drop chances for boss mobs (0.0 = 0%, 1.0 = 100%)").push("boss_mob_drops");
        BOSS_LEGENDARY_CHANCE = BUILDER.comment("Chance for legendary bounty bag drops from boss mobs").defineInRange("bossLegendaryChance", 0.5, 0.0, 1.0);
        BOSS_EPIC_CHANCE = BUILDER.comment("Chance for epic bounty bag drops from boss mobs").defineInRange("bossEpicChance", 0.75, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.comment("Nether drop rate multipliers").push("nether_bonuses");
        NETHER_LEGENDARY_MULTIPLIER = BUILDER.comment("Multiplier for legendary drops in the Nether").defineInRange("netherLegendaryMultiplier", 2.0, 1.0, 10.0);
        NETHER_EPIC_MULTIPLIER = BUILDER.comment("Multiplier for epic drops in the Nether").defineInRange("netherEpicMultiplier", 2.0, 1.0, 10.0);
        NETHER_SUPER_RARE_MULTIPLIER = BUILDER.comment("Multiplier for super rare drops in the Nether").defineInRange("netherSuperRareMultiplier", 1.5, 1.0, 10.0);
        BUILDER.pop();
        BUILDER.comment("Mob type configuration").push("mob_types");
        ALLOWED_MOB_TYPES = BUILDER.comment("List of mob types that can drop bounty bags (use entity type registry names)").defineList("allowedMobTypes", List.of("minecraft:zombie", "minecraft:skeleton", "minecraft:creeper", "minecraft:spider", "minecraft:cave_spider", "minecraft:enderman", "minecraft:blaze", "minecraft:ghast", "minecraft:witch", "minecraft:pillager", "minecraft:vindicator", "minecraft:evoker", "minecraft:husk", "minecraft:stray", "minecraft:drowned", "minecraft:phantom", "minecraft:ravager", "minecraft:piglin_brute", "minecraft:zombified_piglin", "minecraft:hoglin", "minecraft:zoglin"), obj -> obj instanceof String);
        BOSS_MOB_TYPES = BUILDER.comment("List of mob types considered as bosses (use entity type registry names)").defineList("bossMobTypes", List.of("minecraft:ender_dragon", "minecraft:wither"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("Individual mob drop rate multipliers").push("individual_mob_multipliers");
        ZOMBIE_DROP_MULTIPLIER = BUILDER.comment("Drop rate multiplier specifically for zombies").defineInRange("zombieDropMultiplier", 1.0, 0.0, 10.0);
        SKELETON_DROP_MULTIPLIER = BUILDER.comment("Drop rate multiplier specifically for skeletons").defineInRange("skeletonDropMultiplier", 1.0, 0.0, 10.0);
        CREEPER_DROP_MULTIPLIER = BUILDER.comment("Drop rate multiplier specifically for creepers").defineInRange("creeperDropMultiplier", 1.2, 0.0, 10.0);
        SPIDER_DROP_MULTIPLIER = BUILDER.comment("Drop rate multiplier specifically for spiders").defineInRange("spiderDropMultiplier", 0.8, 0.0, 10.0);
        ENDERMAN_DROP_MULTIPLIER = BUILDER.comment("Drop rate multiplier specifically for endermen").defineInRange("endermanDropMultiplier", 1.5, 0.0, 10.0);
        BUILDER.pop();
        BUILDER.comment("Custom loot configuration - only used if useCustomLoot is true").push("loot_configuration");
        BUILDER.comment("Rare bounty bag loot").push("rare_loot");
        RARE_MIN_ITEMS = BUILDER.comment("Minimum number of items in rare bounty bags").defineInRange("minItems", 1, 1, 10);
        RARE_MAX_ITEMS = BUILDER.comment("Maximum number of items in rare bounty bags").defineInRange("maxItems", 1, 1, 15);
        RARE_LOOT_ITEMS = BUILDER.comment("List of items for rare bounty bags. Format: 'item_id:count:weight' or 'item_id:count:weight:enchanted'").defineList("items", List.of("minecraft:iron_sword:1:20:enchanted", "minecraft:iron_pickaxe:1:18:enchanted", "minecraft:iron_axe:1:16:enchanted", "minecraft:bow:1:15:enchanted", "minecraft:iron_chestplate:1:12:enchanted", "minecraft:iron_helmet:1:10:enchanted", "minecraft:shield:1:8:enchanted", "minecraft:crossbow:1:6:enchanted"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("Super rare bounty bag loot").push("super_rare_loot");
        SUPER_RARE_MIN_ITEMS = BUILDER.comment("Minimum number of items in super rare bounty bags").defineInRange("minItems", 1, 1, 10);
        SUPER_RARE_MAX_ITEMS = BUILDER.comment("Maximum number of items in super rare bounty bags").defineInRange("maxItems", 1, 1, 15);
        SUPER_RARE_LOOT_ITEMS = BUILDER.comment("List of items for super rare bounty bags. Format: 'item_id:count:weight' or 'item_id:count:weight:enchanted'").defineList("items", List.of("minecraft:diamond_sword:1:25:enchanted", "minecraft:diamond_pickaxe:1:20:enchanted", "minecraft:diamond_axe:1:18:enchanted", "minecraft:diamond_chestplate:1:15:enchanted", "minecraft:diamond_helmet:1:12:enchanted", "minecraft:trident:1:10:enchanted", "minecraft:enchanted_golden_apple:2:8", "minecraft:ender_chest:1:6", "minecraft:totem_of_undying:1:5"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("Epic bounty bag loot").push("epic_loot");
        EPIC_MIN_ITEMS = BUILDER.comment("Minimum number of items in epic bounty bags").defineInRange("minItems", 1, 1, 10);
        EPIC_MAX_ITEMS = BUILDER.comment("Maximum number of items in epic bounty bags").defineInRange("maxItems", 1, 1, 15);
        EPIC_LOOT_ITEMS = BUILDER.comment("List of items for epic bounty bags. Format: 'item_id:count:weight' or 'item_id:count:weight:enchanted'").defineList("items", List.of("minecraft:netherite_sword:1:20:enchanted", "minecraft:netherite_pickaxe:1:18:enchanted", "minecraft:netherite_axe:1:16:enchanted", "minecraft:netherite_chestplate:1:15:enchanted", "minecraft:netherite_helmet:1:12:enchanted", "minecraft:elytra:1:10", "minecraft:beacon:1:8", "minecraft:shulker_box:1:6", "minecraft:enchanted_book:1:5:enchanted"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("Legendary bounty bag loot").push("legendary_loot");
        LEGENDARY_MIN_ITEMS = BUILDER.comment("Minimum number of items in legendary bounty bags").defineInRange("minItems", 1, 1, 10);
        LEGENDARY_MAX_ITEMS = BUILDER.comment("Maximum number of items in legendary bounty bags").defineInRange("maxItems", 1, 1, 15);
        LEGENDARY_LOOT_ITEMS = BUILDER.comment("List of items for legendary bounty bags. Format: 'item_id:count:weight' or 'item_id:count:weight:enchanted'").defineList("items", List.of("minecraft:netherite_sword:1:25:enchanted", "minecraft:netherite_pickaxe:1:20:enchanted", "minecraft:netherite_axe:1:18:enchanted", "minecraft:netherite_chestplate:1:15:enchanted", "minecraft:netherite_helmet:1:12:enchanted", "minecraft:elytra:1:10", "minecraft:nether_star:1:8", "minecraft:beacon:1:6", "minecraft:totem_of_undying:2:5", "minecraft:enchanted_golden_apple:3:4", "minecraft:heart_of_the_sea:1:3", "minecraft:dragon_egg:1:2"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

