/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import net.darkhax.badmobs.config.Configuration;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="badmobs")
public class BadMobs {
    public static final Logger LOG = LogManager.getLogger((String)"Bad Mobs");
    private Configuration config;

    public BadMobs() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::onSpawnFinalized);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            this.config = new Configuration();
            return this.config;
        });
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_9236_().f_46443_ && this.config != null && !this.config.allowSpawn((Entity)mob, mob.getSpawnType())) {
                event.setCanceled(true);
                mob.m_146870_();
            }
        }
    }

    private void onSpawnFinalized(MobSpawnEvent.FinalizeSpawn event) {
        if (this.config != null && !event.getEntity().m_9236_().f_46443_ && !this.config.allowSpawn((Entity)event.getEntity(), event.getSpawnType())) {
            event.setSpawnCancelled(true);
        }
    }
}

