/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.config.util;

import it.hurts.octostudios.octolib.modules.config.annotations.CfgConstructor;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.ArrayEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.CfgTag;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.CompoundEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.ConfigEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.DeconstructedObjectEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.EnumEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.ObjectEntry;
import it.hurts.octostudios.octolib.modules.config.cfgbuilder.scalar.ScalarEntry;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ConstructorExt
extends Constructor {
    protected Map<Class<?>, Construct> typeConstructorsMap = new IdentityHashMap();
    protected Set<Class<?>> passedClasses = new HashSet();

    public ConstructorExt(LoaderOptions loadingConfig) {
        this(Object.class, loadingConfig);
    }

    public ConstructorExt(Class<?> theRoot, LoaderOptions loadingConfig) {
        super(theRoot, loadingConfig);
        this.initConstructors();
    }

    public ConstructorExt(TypeDescription theRoot, LoaderOptions loadingConfig) {
        super(theRoot, loadingConfig);
        this.initConstructors();
    }

    public ConstructorExt(TypeDescription theRoot, Collection<TypeDescription> moreTDs, LoaderOptions loadingConfig) {
        super(theRoot, moreTDs, loadingConfig);
        this.initConstructors();
    }

    public ConstructorExt(String theRoot, LoaderOptions loadingConfig) throws ClassNotFoundException {
        super(theRoot, loadingConfig);
        this.initConstructors();
    }

    public Object constructObject(Node node) {
        return super.constructObject(node);
    }

    protected void initConstructors() {
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMappingCustomized());
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequenceCustomizable());
        this.typeConstructorsMap.put(CompoundEntry.class, (Construct)new ConstructEntry());
        this.typeConstructorsMap.put(DeconstructedObjectEntry.class, (Construct)new ConstructMappedEntry());
        this.typeConstructorsMap.put(ArrayEntry.class, (Construct)new ConstructMappedEntry());
        this.yamlConstructors.put(CompoundEntry.COMPOUND_CFG_TAG.yamlTag(), new ConstructEntry());
        this.yamlConstructors.put(DeconstructedObjectEntry.DECONSTRUCTED_CFG_TAG.yamlTag(), new ConstructMappedEntry());
    }

    protected Object newInstance(Class<?> ancestor, Node node, boolean tryDefault) {
        block9: {
            try {
                TypeDescription td;
                Object instance;
                Class type = node.getType();
                if (this.typeDefinitions.containsKey(type) && (instance = (td = (TypeDescription)this.typeDefinitions.get(type)).newInstance(node)) != null) {
                    return instance;
                }
                if (!tryDefault) break block9;
                try {
                    Class newType;
                    if (type.isAnonymousClass()) {
                        node.setType(String.class);
                        node.setType(type.getSuperclass());
                        return this.newInstance(ancestor, node, tryDefault);
                    }
                    if (ancestor.isAssignableFrom(type) && !Modifier.isAbstract(type.getModifiers())) {
                        java.lang.reflect.Constructor c = type.getDeclaredConstructor(new Class[0]);
                        c.setAccessible(true);
                        return c.newInstance(new Object[0]);
                    }
                    if (node.getTag().isCustomGlobal() && (newType = this.getClassForNode(node)) != type && type.isAssignableFrom(newType)) {
                        node.setType(newType);
                        return this.newInstance(ancestor, node, tryDefault);
                    }
                }
                catch (NoSuchMethodException e) {
                    if (node.getNodeId() != NodeId.mapping) {
                        throw e;
                    }
                    MappingNode mappingNode = (MappingNode)node;
                    java.lang.reflect.Constructor c = type.getDeclaredConstructor((Class[])mappingNode.getValue().stream().map(t -> t.getValueNode().getType()).toArray(Class[]::new));
                    c.setAccessible(true);
                    return c.newInstance(mappingNode.getValue().stream().map(NodeTuple::getValueNode).map(this::constructObject).toArray(Object[]::new));
                }
            }
            catch (Exception e) {
                throw new YAMLException((Throwable)e);
            }
        }
        return NOT_INSTANTIATED_OBJECT;
    }

    protected void createDefinition(Class<?> type) {
        List<java.lang.reflect.Constructor> constructors = Arrays.stream(type.getConstructors()).filter(c -> c.isAnnotationPresent(CfgConstructor.class)).toList();
        if (constructors.size() > 1) {
            throw new RuntimeException("Only one constructor in class can be annotated with @CfgConstructor.");
        }
        if (!constructors.isEmpty()) {
            final java.lang.reflect.Constructor c2 = constructors.get(0);
            final String[] props = c2.getAnnotation(CfgConstructor.class).value();
            c2.setAccessible(true);
            if (props.length != c2.getParameterCount()) {
                throw new IncompleteAnnotationException(CfgConstructor.class, "Property count must be equal to constructor arguments count.");
            }
            Iterator iterator = Arrays.stream(c2.getParameterTypes()).iterator();
            for (String prop : props) {
                if (!this.getPropertyUtils().getProperty(type, prop).getType().isAssignableFrom((Class)iterator.next())) continue;
                throw new IncompleteAnnotationException(CfgConstructor.class, "Property types and order must be the same as in constructor.");
            }
            this.addTypeDescription(new TypeDescription(type){

                public Object newInstance(Node node) {
                    if (node.getNodeId() != NodeId.mapping) {
                        return super.newInstance(node);
                    }
                    Map<String, Object> map = ((MappingNode)node).getValue().stream().collect(Collectors.toMap(t -> ((ScalarNode)t.getKeyNode()).getValue(), t -> ConstructorExt.this.constructObject(t.getValueNode())));
                    try {
                        return c2.newInstance(Arrays.stream(props).map(map::get).toArray());
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    protected Construct getConstructor(Node node) {
        Class type = node.getType();
        if (type != null && !this.passedClasses.contains(type)) {
            this.createDefinition(type);
        }
        return super.getConstructor(node);
    }

    public class ConstructMappingCustomized
    extends Constructor.ConstructMapping {
        public ConstructMappingCustomized() {
            super((Constructor)ConstructorExt.this);
        }

        public Object construct(Node node) {
            MappingNode mnode = (MappingNode)node;
            Construct construct = ConstructorExt.this.typeConstructorsMap.get(node.getType());
            if (construct != null) {
                return construct.construct(node);
            }
            return super.construct((Node)mnode);
        }

        public void construct2ndStep(Node node, Object object) {
            Construct construct = ConstructorExt.this.typeConstructorsMap.get(node.getType());
            if (construct != null) {
                construct.construct2ndStep(node, object);
                return;
            }
            super.construct2ndStep(node, object);
        }
    }

    public class ConstructSequenceCustomizable
    extends Constructor.ConstructSequence {
        public ConstructSequenceCustomizable() {
            super((Constructor)ConstructorExt.this);
        }

        public Object construct(Node node) {
            Construct construct = ConstructorExt.this.typeConstructorsMap.get(node.getType());
            if (construct != null) {
                return construct.construct(node);
            }
            return super.construct(node);
        }
    }

    public class ConstructEntry
    extends AbstractConstruct {
        public Object construct(Node node) {
            return switch (node.getNodeId()) {
                default -> throw new IncompatibleClassChangeError();
                case NodeId.scalar -> this.constructScalar(node);
                case NodeId.mapping -> this.constructMappingObject(node);
                case NodeId.sequence -> this.constructSequence(node);
                case NodeId.anchor -> this.constructAnchor(node);
            };
        }

        protected ConfigEntry constructSequence(Node valueNode) {
            ArrayEntry arrayEntry = new ArrayEntry(valueNode.getTag() == CfgTag.SEQ.yamlTag() ? null : (CfgTag.by(valueNode.getTag()).equals(ArrayEntry.SEQ_I) ? CfgTag.SEQ : CfgTag.by(valueNode.getTag())));
            SequenceNode sequenceNode = (SequenceNode)valueNode;
            for (Node element : sequenceNode.getValue()) {
                arrayEntry.add((ConfigEntry)this.construct(element));
            }
            return arrayEntry;
        }

        protected ConfigEntry constructMappingObject(Node valueNode) {
            if (valueNode.getTag() == null || valueNode.getTag() == Tag.MAP || valueNode.getTag().equals((Object)CompoundEntry.COMPOUND_CFG_TAG.yamlTag())) {
                return this.constructMapping(new CompoundEntry(), (MappingNode)valueNode);
            }
            return new ObjectEntry(CfgTag.by(valueNode.getTag()), ConstructorExt.this.constructObject(valueNode));
        }

        protected CompoundEntry constructMapping(CompoundEntry map, MappingNode mnode) {
            for (NodeTuple tuple : mnode.getValue()) {
                Node keyNode = tuple.getKeyNode();
                String key = ConstructorExt.this.constructObject(tuple.getKeyNode()).toString();
                ConfigEntry value = (ConfigEntry)this.construct(tuple.getValueNode());
                map.put(key, value);
                if (keyNode.getBlockComments() != null) {
                    value.setBlockComment(keyNode.getBlockComments().stream().map(l -> l.getValue().substring(1)).collect(Collectors.joining("\n")));
                }
                if (keyNode.getInLineComments() == null) continue;
                value.setInlineComment(keyNode.getInLineComments().stream().map(l -> l.getValue().substring(1)).collect(Collectors.joining("\n")));
            }
            return map;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ScalarEntry constructScalar(Node valueNode) {
            CompoundEntry.ScalarFactory factory = CompoundEntry.SCALAR_FACTORIES.get(CfgTag.by(valueNode.getTag()));
            if (factory != null) return factory.create(ConstructorExt.this.constructObject(valueNode));
            if (!valueNode.getTag().getValue().endsWith(".enum")) throw new YAMLException("Unsupported scalar node tag in compound: " + String.valueOf(valueNode.getTag()));
            valueNode.setTag(new Tag(valueNode.getTag().getValue().replace(".enum", "")));
            return new EnumEntry((Enum)ConstructorExt.this.constructObject(valueNode));
        }

        protected ConfigEntry constructAnchor(Node valueNode) {
            throw new UnsupportedOperationException();
        }
    }

    public class ConstructMappedEntry
    extends ConstructEntry {
        @Override
        protected ConfigEntry constructMappingObject(Node valueNode) {
            MappingNode mappingNode = (MappingNode)valueNode;
            if (valueNode.getTag() == null || valueNode.getTag() == Tag.MAP) {
                return this.constructMapping(new CompoundEntry(), (MappingNode)valueNode);
            }
            CfgTag tag = CfgTag.by(mappingNode.getTag());
            mappingNode.setTag(Tag.MAP);
            mappingNode.setType(DeconstructedObjectEntry.class);
            return this.constructMapping(new DeconstructedObjectEntry(tag), (MappingNode)valueNode);
        }
    }
}

