/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.projectile;

import fuzs.illagerinvasion.init.ModRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Hatchet
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<Boolean> DATA_ENCHANTED = SynchedEntityData.m_135353_(Hatchet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack hatchetStack = new ItemStack((ItemLike)ModRegistry.PLATINUM_INFUSED_HATCHET_ITEM.get());
    private boolean dealtDamage;

    public Hatchet(EntityType<? extends Hatchet> entityType, Level world) {
        super(entityType, world);
    }

    public Hatchet(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)ModRegistry.HATCHET_ENTITY_TYPE.get(), owner, world);
        this.hatchetStack = stack.m_41777_();
        this.f_19804_.m_135381_(DATA_ENCHANTED, (Object)stack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ENCHANTED, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected ItemStack m_7941_() {
        return this.hatchetStack.m_41777_();
    }

    public boolean isEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ENCHANTED);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity owner = this.m_19749_();
        Entity target = entityHitResult.m_82443_();
        float f = 8.0f;
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            f += EnchantmentHelper.m_44833_((ItemStack)this.hatchetStack, (MobType)livingEntity.m_6336_());
        }
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (target.m_6469_(damageSource, f)) {
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float g = 1.0f;
        this.m_5496_(soundEvent, g, 1.0f);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Hatchet", 10)) {
            this.hatchetStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Hatchet"));
        }
        this.dealtDamage = nbt.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Hatchet", (Tag)this.hatchetStack.m_41739_(new CompoundTag()));
        nbt.m_128379_("DealtDamage", this.dealtDamage);
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModRegistry.PLATINUM_INFUSED_HATCHET_ITEM.get());
    }

    public float getAgeException() {
        if (!this.f_36703_) {
            return this.f_19797_;
        }
        return 1.0f;
    }
}

