/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.util.EnchantToolUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Archivist
extends SpellcasterIllager {
    private AbstractIllager enchantTarget;
    private int levitateTargetsCooldown;
    private int enchantAlliesCooldown;

    public Archivist(EntityType<? extends Archivist> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(4, (Goal)new LevitateTargetsGoal());
        this.f_21345_.m_25352_(3, (Goal)new EnchantAllyGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModRegistry.ARCHIVIST_AMBIENT_SOUND_EVENT.get();
    }

    protected void m_8024_() {
        --this.levitateTargetsCooldown;
        --this.enchantAlliesCooldown;
        super.m_8024_();
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        if (other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ARCHIVIST_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ARCHIVIST_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.ARCHIVIST_HURT_SOUND_EVENT.get();
    }

    @Nullable
    AbstractIllager getEnchantTarget() {
        return this.enchantTarget;
    }

    void setEnchantTarget(@Nullable AbstractIllager entity) {
        this.enchantTarget = entity;
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModRegistry.SORCERER_COMPLETE_CAST_SOUND_EVENT.get();
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Archivist.this);
        }

        public void m_8037_() {
            if (Archivist.this.m_5448_() != null) {
                Archivist.this.m_21563_().m_24960_((Entity)Archivist.this.m_5448_(), (float)Archivist.this.m_8085_(), (float)Archivist.this.m_8132_());
            }
        }
    }

    public class LevitateTargetsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public LevitateTargetsGoal() {
            super((SpellcasterIllager)Archivist.this);
        }

        public boolean m_8036_() {
            if (Archivist.this.m_5448_() == null) {
                return false;
            }
            return Archivist.this.levitateTargetsCooldown < 0 && !this.getTargets().isEmpty();
        }

        private void knockBack(Entity entity) {
            double d = entity.m_20185_() - Archivist.this.m_20185_();
            double e = entity.m_20189_() - Archivist.this.m_20189_();
            double f = Math.max(d * d + e * e, 0.001);
            entity.m_5997_(d / f * 5.0, 0.6, e / f * 5.0);
        }

        protected void knockback(LivingEntity target) {
            this.knockBack((Entity)target);
            target.f_19864_ = true;
        }

        private List<LivingEntity> getTargets() {
            return Archivist.this.m_9236_().m_6443_(LivingEntity.class, Archivist.this.m_20191_().m_82400_(6.0), entity -> !(entity instanceof Monster) && EntitySelector.f_20406_.test(entity));
        }

        private void buff(LivingEntity entity) {
            this.knockback(entity);
            entity.m_6469_(Archivist.this.m_269291_().m_269425_(), 4.0f);
        }

        protected void m_8130_() {
            Archivist.this.levitateTargetsCooldown = 220;
            this.getTargets().forEach(this::buff);
            double x = Archivist.this.m_20185_();
            double y = Archivist.this.m_20186_() + 1.0;
            double z = Archivist.this.m_20189_();
            ((ServerLevel)Archivist.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 150, 3.0, 3.0, 3.0, 0.1);
        }

        protected int m_8069_() {
            return 50;
        }

        protected int m_8089_() {
            return 50;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_12053_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class EnchantAllyGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeEnchantableMobPredicate;
        private int targetId;

        public EnchantAllyGoal() {
            super((SpellcasterIllager)Archivist.this);
            this.closeEnchantableMobPredicate = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(livingEntity -> !(livingEntity instanceof Archivist));
        }

        public boolean canEnchant() {
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            return hostileEntity != null && EnchantToolUtil.eligibleForEnchant((LivingEntity)hostileEntity);
        }

        public boolean m_8036_() {
            if (Archivist.this.m_5448_() == null) {
                return false;
            }
            if (Archivist.this.enchantAlliesCooldown >= 0) {
                return false;
            }
            if (Archivist.this.m_33736_()) {
                return false;
            }
            List list = Archivist.this.m_9236_().m_45971_(AbstractIllager.class, this.closeEnchantableMobPredicate, (LivingEntity)Archivist.this, Archivist.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Archivist.this.setEnchantTarget((AbstractIllager)list.get(Archivist.this.f_19796_.m_188503_(list.size())));
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            if (hostileEntity.m_19879_() == this.targetId) {
                return false;
            }
            return this.canEnchant();
        }

        public void m_8041_() {
            super.m_8041_();
            Archivist.this.setEnchantTarget(null);
        }

        protected void m_8130_() {
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            if (hostileEntity != null) {
                this.targetId = hostileEntity.m_19879_();
            }
            EnchantToolUtil.enchantHeldGear((LivingEntity)hostileEntity);
            double x = hostileEntity.m_20185_();
            double y = hostileEntity.m_20186_() + 1.5;
            double z = hostileEntity.m_20189_();
            if (Archivist.this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)Archivist.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 50, 1.0, 2.0, 1.0, 0.1);
            }
            Archivist.this.enchantAlliesCooldown = 300;
        }

        protected int m_8069_() {
            return 50;
        }

        protected int m_8089_() {
            return 50;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.SORCERER_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.ENCHANT_ILLAGER_SPELL;
        }
    }
}

