/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.core.mixin.common.MultilineTextFieldAccess;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.IFocusableWidget;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class MultilineTextBox
extends Widget
implements IFocusableWidget {
    private final Font font;
    private boolean isFocused = false;
    private MultilineTextField textField;
    private Component placeHolder = Component.m_237119_();
    private int frame;
    private Consumer<String> valueListener = str -> {};

    public MultilineTextBox(Panel panel) {
        super(panel);
        this.font = this.getGui().getTheme().getFont();
        this.createTextField("", 100);
    }

    @Override
    public void setWidth(int v) {
        super.setWidth(v);
        this.createTextField(this.textField.m_239618_(), this.width);
        this.recalculateHeight();
    }

    private void createTextField(String text, int width) {
        this.textField = new MultilineTextField(this.font, width);
        this.textField.m_239257_(this::scrollToCursor);
        this.textField.m_239677_(text);
        this.textField.m_239919_(this.valueListener);
    }

    public void setValueListener(Consumer<String> valueListener) {
        this.valueListener = valueListener;
        this.textField.m_239919_(valueListener);
    }

    @Override
    public final boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public final void setFocused(boolean focused) {
        this.isFocused = focused;
        if (focused) {
            this.getGui().setFocusedWidget(this);
        }
    }

    public String getText() {
        return this.textField.m_239618_();
    }

    public void setText(String text) {
        this.textField.m_239677_(text);
        this.recalculateHeight();
    }

    private void recalculateHeight() {
        int n = this.innerPadding() * 2;
        int n2 = this.textField.m_239340_();
        Objects.requireNonNull(this.font);
        this.height = n + n2 * 9;
    }

    public void seekCursor(Whence whence, int pos) {
        this.textField.m_239797_(whence, pos);
    }

    public void setPlaceHolder(Component placeHolder) {
        this.placeHolder = placeHolder;
    }

    public void setSelecting(boolean selecting) {
        this.textField.m_239950_(selecting);
    }

    public boolean hasSelection() {
        return this.textField.m_239344_();
    }

    public String getSelectedText() {
        return this.textField.m_240059_();
    }

    public void insertText(String toInsert) {
        this.textField.m_240015_(toInsert);
        this.recalculateHeight();
    }

    public int cursorPos() {
        return this.textField.m_239456_();
    }

    public void selectCurrentLine() {
        MultilineTextField.StringView view = this.textField.m_239144_(this.textField.m_239268_());
        this.textField.m_239950_(false);
        this.textField.m_239797_(Whence.ABSOLUTE, view.f_238590_());
        this.textField.m_239950_(true);
        this.textField.m_239797_(Whence.ABSOLUTE, view.f_238654_());
    }

    public StringExtents getLineView() {
        return StringExtents.of(this.textField.m_239144_(this.textField.m_239268_()));
    }

    public StringExtents getLineView(int line) {
        return StringExtents.of(this.textField.m_239144_(line));
    }

    public StringExtents getSelected() {
        return StringExtents.of(this.textField.m_239982_());
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (this.isMouseOver()) {
            if (button.isLeft()) {
                this.setFocused(true);
                this.textField.m_239950_(Screen.m_96638_());
                this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            }
            return true;
        }
        this.setFocused(false);
        return false;
    }

    @Override
    public boolean mouseDoubleClicked(MouseButton button) {
        if (super.mouseDoubleClicked(button)) {
            return true;
        }
        if (this.isMouseOver() && button.isLeft()) {
            this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            MultilineTextField.StringView view = this.textField.m_239637_();
            this.textField.m_239797_(Whence.ABSOLUTE, view.f_238590_());
            ((MultilineTextFieldAccess)this.textField).setSelectCursor(view.f_238654_());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int button, double dragX, double dragY) {
        if (super.mouseDragged(button, dragX, dragY)) {
            return true;
        }
        if (this.isMouseOver()) {
            this.textField.m_239950_(true);
            this.setCursorPos(this.getMouseX(), (int)((double)this.getMouseY() - this.parent.getScrollY()));
            this.textField.m_239950_(Screen.m_96638_());
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(Key key) {
        boolean res = this.textField.m_239711_(key.keyCode);
        this.recalculateHeight();
        return this.isFocused() && !key.esc() || res;
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.isFocused() && SharedConstants.m_136188_((char)c)) {
            this.textField.m_240015_(Character.toString(c));
            this.recalculateHeight();
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        String s = this.getText();
        if (s.isEmpty() && !this.isFocused()) {
            theme.drawString(graphics, this.placeHolder, x + 4, y + 4, 1);
            return;
        }
        int cursorPos = this.textField.m_239456_();
        boolean drawCursor = this.isFocused() && this.frame / 6 % 2 == 0;
        boolean cursorInRange = cursorPos < s.length();
        int xPos = 0;
        int k = 0;
        int yPos = this.getY() + this.innerPadding();
        for (MultilineTextField.StringView stringview : this.textField.m_239290_()) {
            Objects.requireNonNull(this.font);
            boolean shouldDrawLine = this.withinContentArea(yPos, yPos + 9);
            if (drawCursor && cursorInRange && cursorPos >= stringview.f_238590_() && cursorPos <= stringview.f_238654_()) {
                if (shouldDrawLine) {
                    xPos = theme.drawString(graphics, s.substring(stringview.f_238590_(), cursorPos), this.getX() + this.innerPadding(), yPos, Color4I.rgb(0xE0E0E0), 0);
                    Color4I color4I = Color4I.rgb(0xA0A0A0);
                    Objects.requireNonNull(this.font);
                    color4I.draw(graphics, xPos - 1, yPos, 1, 9);
                    theme.drawString(graphics, s.substring(cursorPos, stringview.f_238654_()), xPos, yPos, Color4I.rgb(0xE0E0E0), 0);
                }
            } else {
                if (shouldDrawLine) {
                    xPos = theme.drawString(graphics, s.substring(stringview.f_238590_(), stringview.f_238654_()), this.getX() + this.innerPadding(), yPos, Color4I.rgb(0xE0E0E0), 0);
                }
                k = yPos;
            }
            Objects.requireNonNull(this.font);
            yPos += 9;
        }
        if (drawCursor && !cursorInRange && this.withinContentArea(k, k + 9)) {
            theme.drawString(graphics, "_", xPos, k, Color4I.rgb(0xA0A0A0), 0);
        }
        if (this.textField.m_239344_()) {
            MultilineTextField.StringView stringView = this.textField.m_239982_();
            int xPos1 = this.getX() + this.innerPadding();
            yPos = this.getY() + this.innerPadding();
            for (MultilineTextField.StringView stringView1 : this.textField.m_239290_()) {
                if (stringView.f_238590_() <= stringView1.f_238654_()) {
                    if (stringView1.f_238590_() > stringView.f_238654_()) break;
                    if (this.withinContentArea(yPos, yPos + 9)) {
                        int xOff1 = this.font.m_92895_(s.substring(stringView1.f_238590_(), Math.max(stringView.f_238590_(), stringView1.f_238590_())));
                        int xOff2 = stringView.f_238654_() > stringView1.f_238654_() ? this.width - this.innerPadding() : this.font.m_92895_(s.substring(stringView1.f_238590_(), stringView.f_238654_()));
                        Objects.requireNonNull(this.font);
                        this.renderHighlight(graphics, xPos1 + xOff1, yPos, xPos1 + xOff2, yPos + 9);
                    }
                }
                Objects.requireNonNull(this.font);
                yPos += 9;
            }
        }
    }

    private void renderHighlight(GuiGraphics graphics, int x1, int y1, int x2, int y2) {
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        Color4I.rgb(255).draw(graphics, x1, y1, x2 - x1, y2 - y1);
        RenderSystem.disableColorLogicOp();
    }

    private boolean withinContentArea(int y1, int y2) {
        return (double)y1 - this.parent.getScrollY() >= (double)this.getY() && (double)y2 - this.parent.getScrollY() <= (double)(this.getY() + this.height);
    }

    private void setCursorPos(int mouseX, int mouseY) {
        double x = (double)mouseX - (double)this.getX() - (double)this.innerPadding();
        double y = (double)mouseY - (double)this.getY() - (double)this.innerPadding() + this.parent.getScrollY();
        this.seekCursorToPoint(x, y);
    }

    public void seekCursorToPoint(double x, double y) {
        int x1 = Mth.m_14107_((double)x);
        int y1 = Mth.m_14107_((double)(y / 9.0));
        MultilineTextField.StringView stringView = this.textField.m_239144_(Mth.m_14045_((int)y1, (int)0, (int)(this.textField.m_239340_() - 1)));
        String lineSection = this.font.m_92834_(this.textField.m_239618_().substring(stringView.f_238590_(), stringView.f_238654_()), x1);
        int k = lineSection.length();
        this.textField.m_239797_(Whence.ABSOLUTE, stringView.f_238590_() + k);
        if (this.textField.m_239456_() < this.textField.m_239618_().length()) {
            String c;
            int w2;
            int w1 = this.font.m_92895_(lineSection);
            if (x1 <= this.font.m_92895_(this.textField.m_239618_().substring(stringView.f_238590_(), stringView.f_238654_())) && x1 - w1 >= (w2 = this.font.m_92895_(c = String.valueOf(this.textField.m_239618_().charAt(this.textField.m_239456_()))) / 2)) {
                this.textField.m_239797_(Whence.RELATIVE, 1);
            }
        }
    }

    private void scrollToCursor() {
        Objects.requireNonNull(this.font);
        int lh = 9;
        double d0 = this.parent.getScrollY();
        MultilineTextField.StringView stringView = this.textField.m_239144_((int)(d0 / (double)lh));
        if (this.textField.m_239456_() <= stringView.f_238590_()) {
            d0 = this.textField.m_239268_() * lh;
        } else {
            MultilineTextField.StringView stringView1 = this.textField.m_239144_((int)((d0 + (double)this.parent.height) / (double)lh) - 1);
            if (this.textField.m_239456_() > stringView1.f_238654_()) {
                d0 = this.textField.m_239268_() * lh - this.parent.height + lh + this.innerPadding() * 2;
            }
        }
        this.parent.setScrollY(d0);
    }

    private int innerPadding() {
        return 4;
    }

    public record StringExtents(int start, int end) {
        public static StringExtents of(MultilineTextField.StringView view) {
            return new StringExtents(view.f_238590_(), view.f_238654_());
        }
    }
}

