/*
 * Decompiled with CFR 0.152.
 */
package elocindev.animation_overhaul.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import elocindev.animation_overhaul.AnimationOverhaul;
import elocindev.animation_overhaul.api.AnimationHolder;
import elocindev.animation_overhaul.api.ILeanablePlayer;
import elocindev.animation_overhaul.compat.CompatibilityLoader;
import elocindev.animation_overhaul.config.AnimationsConfig;
import elocindev.animation_overhaul.registry.AOAnimationInstance;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerEntityMixin
extends Player
implements ILeanablePlayer {
    @Unique
    private final ModifierLayer<IAnimation> CONTAINER = new ModifierLayer();
    public AnimationHolder anim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_run = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_right = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_left = AnimationHolder.EMPTY;
    public AnimationHolder anim_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_slow_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_landing = AnimationHolder.EMPTY;
    public AnimationHolder anim_swimming = AnimationHolder.EMPTY;
    public AnimationHolder anim_swim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawl_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawling = AnimationHolder.EMPTY;
    public AnimationHolder anim_eating = AnimationHolder.EMPTY;
    public AnimationHolder anim_drinking = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sprint_stop = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_edge_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_elytra_fly = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel_sneak = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_left_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_right_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_forward = AnimationHolder.EMPTY;
    public AnimationHolder anim_rolling = AnimationHolder.EMPTY;
    public AnimationHolder[] anim_jump = new AnimationHolder[2];
    public AnimationHolder[] anim_fall = new AnimationHolder[2];
    public AnimationHolder[] anim_punch = new AnimationHolder[2];
    public AnimationHolder[] anim_punch_sneaking = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing_sneak = new AnimationHolder[2];
    public int punch_index = 0;
    public int jump_index = 0;
    public float leanAmount = 0.0f;
    public float leanMultiplier = 1.0f;
    public float realLeanMultiplier = 1.0f;
    public float squash = 0.0f;
    public float realSquash = 0.0f;
    public float momentum = 0.0f;
    public AnimationsConfig ANIMS = AnimationOverhaul.ANIM_CONFIG;
    public float turnDelta = 0.0f;
    public Vec3 lastPos = new Vec3(0.0, 0.0, 0.0);
    public boolean lastOnGround = false;
    public boolean hasSlowFall = false;
    private int tickCounter = 0;
    KeyframeAnimation currentAnimation = null;
    private boolean modified = false;
    private boolean armAnimationsEnabled = true;

    public AbstractClientPlayerEntityMixin(Level level, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
    }

    private AnimationHolder validateHolder(AnimationHolder holder) {
        if (holder == null) {
            throw new RuntimeException("Missing animation from config! Your config is corrupt, you might have deleted some animations.");
        }
        return holder;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void animation_overhaul$init(ClientLevel level, GameProfile profile, CallbackInfo info) {
        PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)((AbstractClientPlayer)this)).addAnimLayer(1, this.CONTAINER);
        AOAnimationInstance.States cfg = this.ANIMS.enabled_animations;
        this.anim_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "idle"), cfg.idle.enabled));
        this.anim_fall[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "fall_first"), cfg.fall.enabled));
        this.anim_fall[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "fall_second"), cfg.fall.enabled));
        this.anim_jump[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "jump_first"), cfg.jump.enabled));
        this.anim_jump[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "jump_second"), cfg.jump.enabled));
        this.anim_sneak_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sneak_idle"), cfg.sneak_idle.enabled));
        this.anim_sneak_walk = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sneak_walk"), cfg.sneak_walk.enabled));
        this.anim_walk = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "walking"), cfg.walk.enabled));
        this.anim_run = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "running"), cfg.run.enabled));
        this.anim_turn_right = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "turn_right"), cfg.turn_right.enabled));
        this.anim_turn_left = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "turn_left"), cfg.turn_left.enabled));
        this.anim_punch[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "punch_right"), cfg.punch.enabled));
        this.anim_punch[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "punch_left"), cfg.punch.enabled));
        this.anim_punch_sneaking[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "punch_right_sneak"), cfg.punch_sneaking.enabled));
        this.anim_punch_sneaking[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "punch_left_sneak"), cfg.punch_sneaking.enabled));
        this.anim_sword_swing[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sword_swing_first"), cfg.sword_swing.enabled));
        this.anim_sword_swing[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sword_swing_second"), cfg.sword_swing.enabled));
        this.anim_sword_swing_sneak[0] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sword_swing_sneak_first"), cfg.sword_swing_sneak.enabled));
        this.anim_sword_swing_sneak[1] = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sword_swing_sneak_second"), cfg.sword_swing_sneak.enabled));
        this.anim_falling = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "falling"), cfg.falling.enabled));
        this.anim_slow_falling = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "slow_falling"), cfg.slow_falling.enabled));
        this.anim_landing = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "landing"), cfg.landing.enabled));
        this.anim_swimming = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "swimming"), cfg.swimming.enabled));
        this.anim_swim_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "swim_idle"), cfg.swim_idle.enabled));
        this.anim_crawl_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "crawl_idle"), cfg.crawl_idle.enabled));
        this.anim_crawling = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "crawling"), cfg.crawling.enabled));
        this.anim_eating = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "eating"), cfg.eating.enabled));
        this.anim_drinking = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "drinking"), cfg.drinking.enabled));
        this.anim_climbing = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "climbing"), cfg.climbing.enabled));
        this.anim_climbing_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "climbing_idle"), cfg.climbing_idle.enabled));
        this.anim_sprint_stop = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "sprint_stop"), cfg.sprint_stop.enabled));
        this.anim_fence_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "fence_idle"), cfg.fence_idle.enabled));
        this.anim_fence_walk = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "fence_walk"), cfg.fence_walk.enabled));
        this.anim_edge_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "edge_idle"), cfg.edge_idle.enabled));
        this.anim_elytra_fly = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "elytra_fly"), cfg.elytra_fly.enabled));
        this.anim_flint_and_steel = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "flint_and_steel"), cfg.flint_and_steel.enabled));
        this.anim_flint_and_steel_sneak = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "flint_and_steel_sneak"), cfg.flint_and_steel_sneak.enabled));
        this.anim_boat_idle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "boat_idle"), cfg.boat_idle.enabled));
        this.anim_boat_forward = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "boat_forward"), cfg.boat_forward.enabled));
        this.anim_boat_right_paddle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "boat_right_paddle"), cfg.boat_right_paddle.enabled));
        this.anim_boat_left_paddle = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "boat_left_paddle"), cfg.boat_left_paddle.enabled));
        this.anim_rolling = this.validateHolder(new AnimationHolder(new ResourceLocation(AnimationOverhaul.MODID, "rolling"), cfg.rolling.enabled));
    }

    public void m_8119_() {
        boolean onGroundInWater;
        boolean isWalkingForwards;
        Block standingBlock;
        super.m_8119_();
        if (this.m_20159_() && !(this.m_20202_() instanceof Boat)) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter == 20) {
            this.hasSlowFall = this.m_21023_(MobEffects.f_19591_);
            this.tickCounter = 0;
        }
        Level level = this.m_9236_();
        boolean onGround = this.m_20096_();
        float delta = 0.05f;
        Vec3 pos = this.m_20182_();
        if (!this.m_20096_() && this.lastOnGround && this.m_20184_().f_82480_ > 0.0) {
            this.playJumpAnimation();
        }
        boolean onFence = ((standingBlock = level.m_8055_(this.m_20183_().m_7495_()).m_60734_()) instanceof FenceBlock || standingBlock instanceof WallBlock || standingBlock instanceof IronBarsBlock) && this.m_20096_();
        boolean onEdge = level.m_8055_(this.m_20183_().m_7495_()).m_60795_() && this.m_20096_();
        this.leanAmount = this.turnDelta != 0.0f ? MathHelper.lerp((float)(delta * 4.0f), (float)this.leanAmount, (float)(this.f_20883_ - this.f_20884_)) : MathHelper.lerp((float)(delta * 4.0f), (float)this.leanAmount, (float)0.0f);
        this.leanMultiplier = MathHelper.lerp((float)(delta * 8.0f), (float)this.leanMultiplier, (float)this.realLeanMultiplier);
        this.squash = MathHelper.lerp((float)(delta * 8.0f), (float)this.squash, (float)this.realSquash);
        this.realSquash = MathHelper.lerp((float)(delta * 8.0f), (float)this.realSquash, (float)0.0f);
        Vec3f movementVector = new Vec3f((float)(pos.f_82479_ - this.lastPos.f_82479_), 0.0f, (float)(pos.f_82481_ - this.lastPos.f_82481_));
        Vec3f lookVector = new Vec3f((float)Math.cos(Math.toRadians(this.f_20883_ + 90.0f)), 0.0f, (float)Math.sin(Math.toRadians(this.f_20883_ + 90.0f)));
        float movementLength = (float)Math.sqrt(((Float)movementVector.getX()).floatValue() * ((Float)movementVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)movementVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)movementVector.getZ()).floatValue());
        boolean isWalking = movementLength > 0.0f;
        float dotProduct = ((Float)movementVector.getX()).floatValue() * ((Float)lookVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)lookVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)lookVector.getZ()).floatValue();
        boolean bl = isWalkingForwards = isWalking && dotProduct > 0.0f;
        float walk_sign = isWalking ? (isWalkingForwards ? 1.0f : -1.0f) : 0.0f;
        float sprint_multiplier = this.m_20142_() && isWalkingForwards ? 2 : 1;
        this.momentum = MathHelper.lerp((float)(delta * 2.0f * sprint_multiplier), (float)this.momentum, (float)(walk_sign * sprint_multiplier));
        this.realLeanMultiplier = this.realLeanMultiplier < 1.0f ? (this.realLeanMultiplier += 0.1f) : 1.0f;
        AnimationHolder animationToPlay = AnimationHolder.EMPTY;
        boolean bl2 = onGroundInWater = this.m_5842_() && this.m_20075_().m_60812_((BlockGetter)this.m_9236_(), this.m_20183_()).m_83281_();
        if (!this.f_20911_ || this.f_20913_ >= this.getCurrentSwingDuration() / 2 || this.f_20913_ < 0) {
            if (this.m_20159_() && this.m_20202_() instanceof Boat) {
                animationToPlay = this.anim_boat_idle;
                boolean left_paddle = ((Boat)this.m_20202_()).m_38313_(0);
                boolean right_paddle = ((Boat)this.m_20202_()).m_38313_(1);
                if (left_paddle && right_paddle) {
                    animationToPlay = this.anim_boat_forward;
                } else if (left_paddle) {
                    animationToPlay = this.anim_boat_left_paddle;
                } else if (right_paddle) {
                    animationToPlay = this.anim_boat_right_paddle;
                }
            } else if (level.m_8055_(this.m_20183_()).m_60734_() instanceof LadderBlock && !this.m_20096_() && !this.f_20899_) {
                animationToPlay = this.anim_climbing_idle;
                if (this.m_20184_().f_82480_ > 0.0) {
                    animationToPlay = this.anim_climbing;
                }
            } else if (this.m_6117_()) {
                if (this.m_21205_().m_41720_().m_41472_()) {
                    animationToPlay = this.anim_eating;
                }
                if (this.m_21211_().m_41780_() == UseAnim.DRINK) {
                    animationToPlay = this.anim_drinking;
                }
            } else if (this.m_21255_()) {
                animationToPlay = this.anim_elytra_fly;
            } else if (this.m_20096_() || onGroundInWater) {
                animationToPlay = this.anim_idle;
                if (onFence) {
                    animationToPlay = this.anim_fence_idle;
                } else if (onEdge) {
                    animationToPlay = this.anim_edge_idle;
                }
                if (this.turnDelta != 0.0f && !onEdge) {
                    animationToPlay = this.anim_turn_right;
                    if (this.turnDelta < 0.0f) {
                        animationToPlay = this.anim_turn_left;
                    }
                }
                if ((this.m_20072_() || this.m_20077_()) && !onGroundInWater) {
                    if (this.m_6069_() || this.m_20142_()) {
                        animationToPlay = this.anim_swimming;
                    }
                } else if (this.m_20143_()) {
                    animationToPlay = isWalking ? this.anim_crawling : this.anim_crawl_idle;
                } else if (this.m_6144_()) {
                    animationToPlay = this.anim_sneak_idle;
                    if (isWalking || this.turnDelta != 0.0f) {
                        animationToPlay = this.anim_sneak_walk;
                    }
                } else if (isWalking) {
                    if (this.momentum > 1.0f && !isWalkingForwards) {
                        animationToPlay = this.anim_sprint_stop;
                    } else if (this.m_20142_() && !this.m_6117_()) {
                        animationToPlay = this.anim_run;
                    } else {
                        animationToPlay = this.anim_walk;
                        if (onFence) {
                            animationToPlay = this.anim_fence_walk;
                        }
                    }
                }
            } else {
                if (this.f_19789_ > 1.0f) {
                    animationToPlay = this.f_19789_ > 3.0f ? this.anim_falling : this.anim_fall[this.jump_index];
                }
                if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0 && this.hasSlowFall) {
                    animationToPlay = this.anim_slow_falling;
                }
            }
            if (this.m_20072_() || this.m_20077_()) {
                animationToPlay = this.m_6069_() || this.m_20142_() ? this.anim_swimming : this.anim_swim_idle;
            }
        }
        if (animationToPlay != null && animationToPlay.isEnabled()) {
            this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
        }
        if (this.m_6117_()) {
            if (this.m_21211_() != null) {
                UseAnim action = this.m_21211_().m_41780_();
                if (action == UseAnim.BOW || action == UseAnim.CROSSBOW || action == UseAnim.SPYGLASS || action == UseAnim.SPEAR || action == UseAnim.TOOT_HORN || action == UseAnim.BLOCK) {
                    this.disableArmAnimations();
                } else if (this.m_21211_().m_41720_() instanceof FlintAndSteelItem) {
                    animationToPlay = this.anim_flint_and_steel;
                    if (this.m_6144_()) {
                        animationToPlay = this.anim_flint_and_steel_sneak;
                    }
                    if (animationToPlay != null && animationToPlay.isEnabled()) {
                        this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
                    }
                }
            }
        } else {
            this.enableArmAnimations();
        }
        this.lastPos = new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.lastOnGround = onGround;
    }

    public void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        if (this.f_19789_ > 0.0f) {
            if (onGround) {
                if (this.f_19789_ >= 3.0f) {
                    this.playAnimation(this.anim_landing.getAnimation(), 1.0f, 0);
                }
                this.realSquash = -this.f_19789_ / 10.0f;
            } else {
                this.realSquash = Math.min(this.f_19789_ / 20.0f, 0.25f);
            }
        }
        super.m_7840_(heightDifference, onGround, state, landedPosition);
    }

    public void playAnimation(KeyframeAnimation anim) {
        this.playAnimation(anim, 1.0f, 10);
    }

    public void playAnimation(KeyframeAnimation anim, float speed, int fade) {
        this.playAnimation(this.CONTAINER, anim, speed, fade);
    }

    public void playAnimation(ModifierLayer<IAnimation> container, KeyframeAnimation anim, float speed, int fade) {
        if (this.currentAnimation == anim || anim == null) {
            return;
        }
        this.currentAnimation = anim;
        KeyframeAnimation.AnimationBuilder builder = anim.mutableCopy();
        builder.leftArm.setEnabled(this.armAnimationsEnabled);
        builder.rightArm.setEnabled(this.armAnimationsEnabled);
        anim = builder.build();
        if (this.modified) {
            container.removeModifier(0);
        }
        this.modified = true;
        container.addModifierBefore((AbstractModifier)new SpeedModifier(speed));
        container.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fade, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(anim));
        container.setupAnim(0.05f);
    }

    public void disableArmAnimations() {
        if (this.currentAnimation != null && this.armAnimationsEnabled) {
            this.armAnimationsEnabled = false;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(false);
            builder.rightArm.setEnabled(false);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.m_6113_()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
            animationContainer.setupAnim(0.05f);
            animationContainer.tick();
        }
    }

    public void enableArmAnimations() {
        if (this.currentAnimation != null && !this.armAnimationsEnabled) {
            this.armAnimationsEnabled = true;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(true);
            builder.rightArm.setEnabled(true);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.m_6113_()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
        }
    }

    public void playJumpAnimation() {
        this.realLeanMultiplier = 0.0f;
        this.realSquash = -0.1f;
        ++this.jump_index;
        this.jump_index %= 2;
        AnimationHolder anim = this.anim_jump[this.jump_index];
        if (anim != null && anim.isEnabled()) {
            this.playAnimation(this.CONTAINER, anim.getAnimation(), anim.getSpeed(), anim.getFade());
        }
    }

    private int getCurrentSwingDuration() {
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            return 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)this));
        }
        return this.m_21023_(MobEffects.f_19599_) ? 6 + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2 : 6;
    }

    public void m_6674_(InteractionHand hand) {
        super.m_6674_(hand);
        if (this.m_21211_().m_41720_() instanceof FlintAndSteelItem && this.m_6117_()) {
            return;
        }
        if (!this.f_20911_ || this.f_20913_ >= this.getCurrentSwingDuration() / 2 || this.f_20913_ < 0) {
            ++this.punch_index;
            this.punch_index %= 2;
            ItemStack stack = this.m_21205_();
            boolean sword_animations = false;
            if (CompatibilityLoader.BETTER_COMBAT) {
                sword_animations = false;
            }
            if (stack != null) {
                if (stack.m_41720_() instanceof SwordItem) {
                    sword_animations = true;
                } else if (stack.m_41720_() instanceof PickaxeItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof HoeItem || stack.m_41720_() instanceof ShovelItem || stack.m_41720_() instanceof FishingRodItem && this.m_6117_()) {
                    sword_animations = true;
                    if (!AnimationOverhaul.ANIM_CONFIG.hands_behavior.mining) {
                        this.disableArmAnimations();
                        return;
                    }
                }
            } else if (!AnimationOverhaul.ANIM_CONFIG.hands_behavior.punch) {
                this.disableArmAnimations();
                return;
            }
            AnimationHolder hand_anim = null;
            hand_anim = this.m_6144_() ? (sword_animations ? this.anim_sword_swing_sneak[this.punch_index] : this.anim_punch_sneaking[this.punch_index]) : (sword_animations ? this.anim_sword_swing[this.punch_index] : this.anim_punch[this.punch_index]);
            if (!hand_anim.isEnabled()) {
                this.disableArmAnimations();
            }
            if (hand_anim != null) {
                this.playAnimation(hand_anim.getAnimation(), 1.0f, 0);
            }
        }
    }

    @Override
    public float getLeanAmount() {
        return this.leanAmount * 0.01f;
    }

    @Override
    public float getLeanMultiplier() {
        return this.leanMultiplier;
    }

    @Override
    public float getSquash() {
        return this.squash;
    }
}

