/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import noobanidus.mods.lootr.api.advancement.IGenericPredicate;
import org.jetbrains.annotations.NotNull;

public class GenericTrigger<T>
implements CriterionTrigger<Instance<T>> {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners<T>> listeners = Maps.newHashMap();
    private final IGenericPredicate<T> predicate;

    public GenericTrigger(String id, IGenericPredicate<T> predicate) {
        this(new ResourceLocation(id), predicate);
    }

    public GenericTrigger(ResourceLocation id, IGenericPredicate<T> predicate) {
        this.id = id;
        this.predicate = predicate;
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    public void m_6467_(@NotNull PlayerAdvancements advancementsIn, @NotNull CriterionTrigger.Listener<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list == null) {
            list = new Listeners(advancementsIn);
            this.listeners.put(advancementsIn, list);
        }
        list.add(listener);
    }

    public void m_6468_(@NotNull PlayerAdvancements advancementsIn, @NotNull CriterionTrigger.Listener<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.listeners.remove(advancementsIn);
            }
        }
    }

    public void m_5656_(@NotNull PlayerAdvancements advancementsIn) {
        this.listeners.remove(advancementsIn);
    }

    public Instance<T> createInstance(JsonObject jsonObject, DeserializationContext conditionArrayParser) {
        ContextAwarePredicate contextawarepredicate = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"player", (DeserializationContext)conditionArrayParser);
        return this.createInstance(jsonObject, contextawarepredicate, conditionArrayParser);
    }

    public Instance<T> createInstance(JsonObject jsonObject, ContextAwarePredicate context, DeserializationContext conditionArrayParser) {
        return new Instance<T>(this.m_7295_(), context, this.predicate.deserialize(jsonObject));
    }

    public void trigger(ServerPlayer player, T condition) {
        Listeners<T> list = this.listeners.get(player.m_8960_());
        if (list != null) {
            list.trigger(player, condition);
        }
    }

    public static class Listeners<T> {
        PlayerAdvancements advancements;
        Set<CriterionTrigger.Listener<Instance<T>>> listeners = Sets.newHashSet();

        Listeners(PlayerAdvancements advancementsIn) {
            this.advancements = advancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance<T>> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance<T>> listener) {
            this.listeners.remove(listener);
        }

        void trigger(ServerPlayer player, T condition) {
            ArrayList list = Lists.newArrayList();
            for (CriterionTrigger.Listener<Instance<T>> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(player, condition)) continue;
                list.add(listener);
            }
            if (list.size() != 0) {
                for (CriterionTrigger.Listener listener : list) {
                    listener.m_13686_(this.advancements);
                }
            }
        }
    }

    public static class Instance<T>
    extends AbstractCriterionTriggerInstance {
        IGenericPredicate<T> predicate;

        Instance(ResourceLocation location, ContextAwarePredicate contextPredicate, IGenericPredicate<T> predicate) {
            super(location, contextPredicate);
            this.predicate = predicate;
        }

        public boolean test(ServerPlayer player, T event) {
            return this.predicate.test(player, event);
        }
    }
}

