/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.ring;

import com.mojang.datafixers.util.Pair;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class BastionRingItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("compass").maxLevel(0).build()).ability(AbilityData.builder("trade").requiredLevel(5).requiredPoints(2).stat(StatData.builder("rolls").initialValue(0.0, 1.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.BASTION).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int i;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level world = player.m_20193_();
        if (world.m_5776_() || world.m_46472_() != Level.f_46429_) {
            return;
        }
        Piglin piglin = (Piglin)world.m_45963_(Piglin.class, TargetingConditions.f_26872_, (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20191_().m_82400_(5.0));
        if (piglin == null || piglin.m_5448_() == player) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("bastion_remnant"));
        Optional<HolderSet> optional = serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("bastion_remnant"))).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0}));
        if (optional.isEmpty()) {
            return;
        }
        Pair bastion = serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, optional.get(), player.m_20183_(), 100, false);
        if (bastion == null) {
            return;
        }
        BlockPos bastionPos = (BlockPos)bastion.getFirst();
        piglin.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 255, false, false));
        Vec3 currentVec = piglin.m_20182_();
        Vec3 finalVec = currentVec.m_82549_(new Vec3((double)bastionPos.m_123341_(), piglin.m_20186_(), (double)bastionPos.m_123343_()).m_82546_(currentVec).m_82541_().m_82542_(2.0, 2.0, 2.0));
        int distance = (int)Math.round(currentVec.m_82554_(finalVec)) * 20;
        for (i = 0; i < distance; ++i) {
            float x = (float)((finalVec.f_82479_ - currentVec.f_82479_) * (double)i / (double)distance + currentVec.f_82479_);
            float z = (float)((finalVec.f_82481_ - currentVec.f_82481_) * (double)i / (double)distance + currentVec.f_82481_);
            serverLevel.m_8767_(ParticleUtils.constructSimpleSpark(new Color(255, 240, 150), 0.2f - (float)i * 0.00375f, 1, 0.99f), (double)x, piglin.m_20186_() + (double)(piglin.m_20206_() / 1.75f), (double)z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 2; ++i) {
            float angle = 0.02f * (float)(piglin.f_19797_ * 3 + i * 160);
            double extraX = (double)(0.75f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + piglin.m_20185_();
            double extraZ = (double)(0.75f * Mth.m_14089_((float)angle)) + piglin.m_20189_();
            serverLevel.m_8767_(ParticleUtils.constructSimpleSpark(new Color(255, 240, 150), 0.2f, 30, 0.95f), extraX, piglin.m_20186_() + (double)(piglin.m_20206_() / 1.75f), extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.BASTION_RING.get());
            Item item = stack.m_41720_();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            LivingEntity entity2 = event.getEntity();
            if (entity2 instanceof ZombifiedPiglin) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            if (entity2 instanceof Piglin) {
                relic.spreadExperience((LivingEntity)player, stack, 5);
            }
            if (entity2 instanceof PiglinBrute) {
                relic.spreadExperience((LivingEntity)player, stack, 10);
            }
        }
    }
}

