/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.data.provider.DEAdvancementProvider;
import com.barion.dungeons_enhanced.data.provider.DEBiomeTagsProvider;
import com.barion.dungeons_enhanced.data.provider.DELootTableProvider;
import com.barion.dungeons_enhanced.data.provider.DEStructureTagsProvider;
import com.barion.dungeons_enhanced.registry.DEDynamicSpawners;
import com.barion.dungeons_enhanced.registry.DEJigsawTypes;
import com.barion.dungeons_enhanced.registry.DEProcessorLists;
import com.barion.dungeons_enhanced.registry.DEProcessors;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.registry.DETemplatePools;
import com.google.common.reflect.Reflection;
import com.legacy.structure_gel.api.data.providers.RegistrarDatapackEntriesProvider;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeons_enhanced")
public final class DungeonsEnhanced {
    public static final String MOD_ID = "dungeons_enhanced";
    public static final Logger LOGGER = LogManager.getLogger();

    public DungeonsEnhanced() {
        this(FMLJavaModLoadingContext.get());
    }

    public DungeonsEnhanced(FMLJavaModLoadingContext context) {
        IEventBus modBus = context.getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        Reflection.initialize((Class[])new Class[]{DEStructures.class, DEProcessors.class, DETemplatePools.class, DEDynamicSpawners.class});
        modBus.addListener(DungeonsEnhanced::gatherData);
        modBus.addListener(DEJigsawTypes::register);
        RegistrarHandler.registerHandlers((String)MOD_ID, (IEventBus)modBus, (RegistrarHandler[])new RegistrarHandler[]{DETemplatePools.HANDLER, DEProcessorLists.HANDLER});
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean runServer = event.includeServer();
        RegistrarDatapackEntriesProvider registrarProvider = RegistrarHandler.createGenerator((PackOutput)output, (String)MOD_ID, (String[])new String[0]);
        generator.addProvider(event.includeServer(), (DataProvider)registrarProvider);
        CompletableFuture lookup = registrarProvider.getLookupProvider();
        generator.addProvider(runServer, (DataProvider)new DEBiomeTagsProvider(output, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(runServer, (DataProvider)new DELootTableProvider(output));
        generator.addProvider(runServer, (DataProvider)new DEAdvancementProvider(output, existingFileHelper));
        generator.addProvider(runServer, (DataProvider)new DEStructureTagsProvider(output, lookup, existingFileHelper));
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MOD_ID, key);
    }
}

