/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.util.LogHelper;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class Module {
    static final HashMap<ResourceLocation, Module> modules = new HashMap();
    private ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    ForgeConfigSpec.Builder configBuilder;
    private boolean enabled;
    private boolean canBeDisabled;
    private final ResourceLocation id;
    private final String name;
    private String description = "";
    private final String modId;
    private final ModConfig.Type modConfigType;
    private static final Map<Class<? extends Feature>, Feature> loadedFeatures = new HashMap<Class<? extends Feature>, Feature>();
    private final Map<Class<? extends Feature>, Feature> features = new HashMap<Class<? extends Feature>, Feature>();
    static final Object _lock = new Object();
    private static final Type LOAD_FEATURE_TYPE = Type.getType(LoadFeature.class);

    Module(String modId, String moduleId, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)modId, (String)moduleId);
        this.name = name;
        this.enabled = true;
        this.canBeDisabled = true;
        this.modId = modId;
        this.modConfigType = modConfigType;
        this.configBuilder = configBuilder;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::readConfig);
    }

    public void setConfigBuilder(ForgeConfigSpec.Builder builder) {
        if (this.configBuilder == null) {
            this.configBuilder = builder;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<Class<? extends Feature>, Feature> getFeatures() {
        return this.features;
    }

    public void loadConfig() {
        this.enabledConfig = this.canBeDisabled ? (!this.description.equals("") ? this.configBuilder.comment(this.description).define("Enable %s".formatted(this.name), this.enabled) : this.configBuilder.define("Enable %s".formatted(this.name), this.enabled)) : null;
    }

    public void readConfig(ModConfigEvent event) {
        if (event.getConfig().getType() != this.modConfigType || !event.getConfig().getModId().equals(this.modId)) {
            return;
        }
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
        this.features.forEach((clazz, feature) -> feature.readConfig(event));
        this.features.forEach((clazz, feature) -> feature.postReadConfig(event));
    }

    public void pushConfig() {
        if (this.canBeDisabled) {
            if (this.description.isEmpty()) {
                this.configBuilder.push(this.getName());
            } else {
                this.configBuilder.comment(this.description).push(this.getName());
            }
        }
    }

    public void popConfig() {
        if (this.canBeDisabled) {
            this.configBuilder.pop();
        }
    }

    public static void loadFeatures(ModConfig.Type modConfigType, String modId, ClassLoader classLoader) {
        HashSet modulesToLoad = new HashSet();
        ModFileScanData modFileScanData = ModList.get().getModFileById(modId).getFile().getScanResult();
        modFileScanData.getAnnotations().stream().filter(annotation -> LOAD_FEATURE_TYPE.equals((Object)annotation.annotationType())).sorted(Comparator.comparing(a -> a.clazz().getClassName())).forEach(annotation -> {
            try {
                Module.handleFeatureAnnotation(annotation, modConfigType, classLoader, modulesToLoad);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load Module %s".formatted(annotation), e);
            }
        });
        modulesToLoad.forEach(m -> {
            m.pushConfig();
            m.getFeatures().forEach((clazz, feature) -> feature.loadConfig());
            m.popConfig();
        });
    }

    private static void handleFeatureAnnotation(ModFileScanData.AnnotationData annotationData, ModConfig.Type modConfigType, ClassLoader classLoader, Set<Module> modulesToLoad) throws Exception {
        Class<?> clazz;
        Map annotationDataMap = annotationData.annotationData();
        ResourceLocation moduleId = ResourceLocation.parse((String)((String)annotationDataMap.get("module")));
        Module module = modules.get(moduleId);
        if (module == null) {
            LogHelper.warn("No module found with ID %s".formatted(moduleId), new Object[0]);
            return;
        }
        if (module.modConfigType != modConfigType) {
            return;
        }
        Type type = annotationData.clazz();
        Class<?> featureClazz = clazz = Class.forName(type.getClassName(), false, classLoader);
        if (!Module.areRequiredModsLoaded(annotationDataMap, type.getClassName())) {
            return;
        }
        boolean enabledByDefault = annotationDataMap.getOrDefault("enabledByDefault", true);
        boolean canBeDisabled = annotationDataMap.getOrDefault("canBeDisabled", true);
        LogHelper.info("Found (%s) InsaneLib Feature class %s".formatted(modConfigType, type.getClassName()), new Object[0]);
        Feature feature = Module.instantiateFeature(clazz, module, enabledByDefault, canBeDisabled);
        module.getFeatures().put(featureClazz, feature);
        Module.getAllLoadedFeatures().put(featureClazz, feature);
        modulesToLoad.add(module);
    }

    private static boolean areRequiredModsLoaded(Map<String, Object> annotationDataMap, String className) {
        if (!annotationDataMap.containsKey("requiresMods")) {
            return true;
        }
        List requiredMods = (List)annotationDataMap.get("requiresMods");
        for (String modId : requiredMods) {
            if (ModList.get().isLoaded(modId)) continue;
            LogHelper.info("Feature %s not loaded because %s is not present".formatted(className, modId), new Object[0]);
            return false;
        }
        return true;
    }

    private static Feature instantiateFeature(Class<?> clazz, Module module, boolean enabledByDefault, boolean canBeDisabled) {
        try {
            Constructor<?> ctor = clazz.getDeclaredConstructor(Module.class, Boolean.TYPE, Boolean.TYPE);
            return (Feature)ctor.newInstance(module, enabledByDefault, canBeDisabled);
        }
        catch (NoSuchMethodException e) {
            try {
                Feature feature = (Feature)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                feature.init(module, enabledByDefault, canBeDisabled);
                return feature;
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to instantiate Feature (no valid constructor): " + clazz.getName(), ex);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate Feature with full constructor: " + clazz.getName(), e);
        }
    }

    public static Map<Class<? extends Feature>, Feature> getAllLoadedFeatures() {
        return loadedFeatures;
    }

    @Nullable
    public static Feature getFeature(Class<? extends Feature> featureClazz) {
        return loadedFeatures.get(featureClazz);
    }

    public static Optional<Feature> getFeature(String name) {
        return loadedFeatures.values().stream().filter(feature -> feature.getName().equalsIgnoreCase(name)).findFirst();
    }

    public static class Builder {
        private final Module module;

        private Builder(String modId, String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            this.module = new Module(modId, id, name, modConfigType, configBuilder);
        }

        public static Builder create(String modId, String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            return new Builder(modId, id, name, modConfigType, configBuilder);
        }

        public static Builder create(String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            String[] split = id.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("id seems to not be a valid Resource Location. Must be modid:module_id");
            }
            return new Builder(split[0], split[1], name, modConfigType, configBuilder);
        }

        public Builder setDescription(String description) {
            this.module.description = description;
            return this;
        }

        public Builder canBeDisabled(boolean canBeDisabled) {
            this.module.canBeDisabled = canBeDisabled;
            return this;
        }

        public Builder enabledByDefault(boolean enabledByDefault) {
            this.module.enabled = enabledByDefault;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Module build() {
            this.module.loadConfig();
            Object object = _lock;
            synchronized (object) {
                modules.putIfAbsent(this.module.id, this.module);
            }
            return this.module;
        }
    }
}

