/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.just_a_raft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.justaraftmod.entities.RaftType;
import com.mrbysco.justaraftmod.init.RaftRegistry;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.Item;

public class JustARaftModule
extends SimpleModule {
    public final ItemOnlyEntrySet<WoodType, Item> rafts = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(WoodType.class, "raft", this.getModItem("oak_raft"), () -> VanillaWoodTypes.OAK, w -> {
        RaftType newRaft = this.getRaft((WoodType)w);
        RaftType.registerRaftType((RaftType)newRaft);
        return new RaftItem(newRaft, new Item.Properties());
    }).addTextureM(this.modRes("entity/raft/oak_raft"), EveryCompat.res("entity/raft/oak_raft_m"), PaletteStrategies.LOG_SIDE_STANDARD)).addTag(this.modRes("rafts"), Registries.f_256913_)).setTabKey(RaftRegistry.RAFT_TAB.getId())).build();

    public JustARaftModule(String modId) {
        super(modId, "jar");
        this.addEntry(this.rafts);
    }

    public RaftType getRaft(WoodType w) {
        String name = this.shortenedId() + "/" + w.getAppendableId();
        return new RaftType(w.planks, () -> (Item)this.rafts.items.get(w), name, EveryCompat.res("textures/entity/raft/" + name + "_raft.png"));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        ResourceLocation recipeLoc = ResType.RECIPES.getPath(this.modRes("oak_raft"));
        executor.accept((manager, sink) -> this.rafts.items.forEach((wood, item) -> {
            try (InputStream recipeStrem = ((Resource)manager.m_213713_(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open the recipe @ " + recipeLoc))).m_215507_();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStrem);
                recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", UtilityTag.getATagOrCreateANew("logs", "caps", (BlockType)wood, sink, manager).toString());
                recipe.getAsJsonObject("result").addProperty("item", Utils.getID((Item)item).toString());
                String newRecipeLoc = this.shortenedId() + "/" + wood.getAppendableId() + "_raft";
                sink.addJson(EveryCompat.res(newRecipeLoc), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for {} : {}", item, (Object)e);
            }
        }));
    }
}

