/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.misc.SpriteExtra;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatSpritesHelper {
    public static Set<SpriteExtra> spriteExtraSet = new HashSet<SpriteExtra>();
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_TOP_LOG_TEXTURE = s -> {
        if ((s = new ResourceLocation(s).m_135815_()).contains("_overlay")) {
            return false;
        }
        return s.contains("_top") || s.contains("_end") || s.contains("_up");
    };
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_SIDE_LOG_TEXTURE = s -> !LOOKS_LIKE_TOP_LOG_TEXTURE.test(s = new ResourceLocation(s).m_135815_()) && (!s.contains("_overlay") || s.contains("_leaves"));
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_LEAF_TEXTURE = s -> !(s = new ResourceLocation(s).m_135815_()).contains("_top") && !s.contains("_bushy") && !s.contains("_snow") && !s.contains("_overlay") && !s.contains("/snow");
    private static final Supplier<WoodType> FLOWERING_AZALEA = WoodTypeRegistry.INSTANCE.makeFutureHolder(new ResourceLocation("ecologics", "flowering_azalea"));
    private static final Supplier<WoodType> AZALEA = WoodTypeRegistry.INSTANCE.makeFutureHolder(new ResourceLocation("ecologics", "azalea"));
    private static final Supplier<WoodType> BRIMWOOD = WoodTypeRegistry.INSTANCE.makeFutureHolder(new ResourceLocation("regions_unexplored", "brimwood"));
    private static final Supplier<WoodType> STRANGEWOOD = WoodTypeRegistry.INSTANCE.makeFutureHolder(new ResourceLocation("aoa", "strangewood"));

    public static void addHardcodedSprites() {
        if (!spriteExtraSet.isEmpty()) {
            for (SpriteExtra currentSprite : spriteExtraSet) {
                CompatSpritesHelper.addOptional(currentSprite.blockId(), currentSprite.textureKey(), currentSprite.resLocTexture());
            }
        }
        TextureCache.registerSpecialTextureForBlock((ItemLike)Blocks.f_50128_, (String)"cactus_log", (ResourceLocation)EveryCompat.res("block/cactus_side"));
        TextureCache.registerSpecialTextureForBlock((ItemLike)Blocks.f_50128_, (String)"cactus_log_top", (ResourceLocation)EveryCompat.res("block/cactus_top"));
        CompatSpritesHelper.addOptional("minecraft:mushroom_stem", "_side", "minecraft:block/mushroom_stem");
        CompatSpritesHelper.addOptional("minecraft:mushroom_stem", "_top", "minecraft:block/mushroom_stem");
        CompatSpritesHelper.addOptional("frightful_winter:snowy_pine_leaves", "_leaves", "frightful_winter:block/snowy_pine_leaves");
        CompatSpritesHelper.addOptional("mcwholidays:snowy_oak_leaves", "_leaves", "mcwholidays:block/snowy_oak_leaves");
        CompatSpritesHelper.addOptional("mcwholidays:snowy_spruce_leaves", "_leaves", "mcwholidays:block/snowy_spruce_leaves");
        CompatSpritesHelper.addOptional("naturaldecormod:saguaro_log", "_side", "naturaldecormod:block/aguaroogew");
        CompatSpritesHelper.addOptional("naturaldecormod:saguaro_log", "_top", "naturaldecormod:block/aguaroogewop");
        CompatSpritesHelper.addOptional("luminous_nether:withered_log", "_side", "luminous_nether:block/ashenlogside");
        CompatSpritesHelper.addOptional("luminous_nether:withered_log", "_top", "luminous_nether:block/ashenlogtop");
        CompatSpritesHelper.addOptional("luminous_nether:stripped_withered_log", "_side", "luminous_nether:block/strippedwitheredlogside");
        CompatSpritesHelper.addOptional("luminous_nether:stripped_withered_log", "_top", "luminous_nether:block/strippedwitheredlogtop");
        CompatSpritesHelper.addOptional("luminous_nether:withered_planks", "_top", "luminous_nether:block/ashplanks");
        CompatSpritesHelper.addOptional("luminous_nether:goldenstem", "_side", "luminous_nether:block/stembase");
        CompatSpritesHelper.addOptional("luminous_nether:goldenstem", "_top", "luminous_nether:block/mushroominside");
        CompatSpritesHelper.addOptional("luminous_nether:shredded_stem", "_side", "luminous_nether:block/mushroomblockside");
        CompatSpritesHelper.addOptional("luminous_nether:shredded_stem", "_top", "luminous_nether:block/mushroomstemtop");
        CompatSpritesHelper.addOptional("luminous_nether:shredded_stem", "_side", "luminous_nether:block/goldenmushroomside");
        CompatSpritesHelper.addOptional("luminous_nether:shredded_stem", "_top", "luminous_nether:block/goldenmushroomtop");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_log", "_side", "mofus_better_end_:block/weepingstarlogside");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_log", "_top", "mofus_better_end_:block/weepingstarlogup");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_stripped_log", "_side", "mofus_better_end_:block/weepingstarrefinedplanks");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_stripped_log", "_top", "mofus_better_end_:block/stipedweepingstarlogup");
        CompatSpritesHelper.addOptional("mofus_better_end_:frost_root_log", "_side", "mofus_better_end_:block/frostrootlogside");
        CompatSpritesHelper.addOptional("mofus_better_end_:frost_root_log", "_top", "mofus_better_end_:block/frostrootlogup");
        CompatSpritesHelper.addOptional("mofus_better_end_:stripped_frost_root_log", "_side", "mofus_better_end_:block/strippedfrostrootlog");
        CompatSpritesHelper.addOptional("mofus_better_end_:stripped_frost_root_log", "_top", "mofus_better_end_:block/strippedfrostrootup");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_planks", "all", "mofus_better_end_:block/weeoingstarplanks");
        CompatSpritesHelper.addOptional("mofus_better_end_:frost_root_plank", "all", "mofus_better_end_:block/frostrootplank");
        CompatSpritesHelper.addOptional("mofus_better_end_:weepingstar_leaf", "_leavse", "mofus_better_end_:block/weepingstarleafs2");
        CompatSpritesHelper.addOptional("mofus_better_end_:frost_root_leaves", "_leavse", "mofus_better_end_:block/frostrootleaves");
        CompatSpritesHelper.addOptional("botanicpledge:yggdrasil_log", "_side", "botanicpledge:block/yggdrasil_log");
        CompatSpritesHelper.addOptional("botanicpledge:stripped_yggdrasil_log", "_side", "botanicpledge:block/stripped_yggdrasil_log");
        CompatSpritesHelper.addOptional("abyssal_decor:white_wood_log", "_side", "abyssal_decor:block/whitewoodstrippedlog");
        CompatSpritesHelper.addOptional("abyssal_decor:white_wood_log", "_top", "abyssal_decor:block/whitewoodstrippedlogtop");
        CompatSpritesHelper.addOptional("abyssal_decor:white_wood_wood", "_side", "abyssal_decor:block/whitewoodstrippedlog");
        CompatSpritesHelper.addOptional("abyssal_decor:white_wood_wood", "_top", "abyssal_decor:block/whitewoodstrippedlog");
        CompatSpritesHelper.addOptional("abyssal_decor:cinnamon_log", "_side", "abyssal_decor:block/cinnamonlogside");
        CompatSpritesHelper.addOptional("abyssal_decor:cinnamon_log", "_top", "abyssal_decor:block/cinnamonlogtop");
        CompatSpritesHelper.addOptional("abyssal_decor:stripped_cinnamon_log", "_side", "abyssal_decor:block/strippedcinnamonlogside");
        CompatSpritesHelper.addOptional("abyssal_decor:stripped_cinnamon_log", "_top", "abyssal_decor:block/strippedcinnamonlogtop");
        CompatSpritesHelper.addOptional("abyssal_decor:blackwood_log", "_side", "abyssal_decor:block/moldylogside");
        CompatSpritesHelper.addOptional("abyssal_decor:blackwood_log", "_top", "abyssal_decor:block/moldylogtop");
        CompatSpritesHelper.addOptional("abyssal_decor:stripped_blackwood_log", "_side", "abyssal_decor:block/blackwoodstrippedlogside");
        CompatSpritesHelper.addOptional("abyssal_decor:stripped_blackwood_log", "_top", "abyssal_decor:block/blackwoodstrippedlogtop");
        CompatSpritesHelper.addOptional("abyssal_decor:blackwood_wood", "_side", "abyssal_decor:block/moldylogside");
        CompatSpritesHelper.addOptional("abyssal_decor:blackwood_wood", "_top", "abyssal_decor:block/moldylogside");
        CompatSpritesHelper.addOptional("deeperdarker:blooming_stem", "_top", "deeperdarker:block/blooming_stem");
        CompatSpritesHelper.addOptional("deeperdarker:stripped_blooming_stem", "_top", "deeperdarker:block/stripped_blooming_stem");
        CompatSpritesHelper.addOptional("piglin_ruins:ominous_stalk_block", "_side", "piglin_ruins:block/ominous_stalk_block_side");
        CompatSpritesHelper.addOptional("piglin_ruins:ominous_stalk_block", "_top", "piglin_ruins:block/ominous_stalk_block_top");
        CompatSpritesHelper.addOptional("astral_dimension:sick_log", "_side", "astral_dimension:block/sick_log");
        CompatSpritesHelper.addOptional("astral_dimension:sick_log", "_top", "astral_dimension:block/sick_log");
        CompatSpritesHelper.addOptional("promenade:sakura_log", "_side", "promenade:block/sakura/log/side");
        CompatSpritesHelper.addOptional("promenade:sakura_log", "_top", "promenade:block/sakura/log/top");
        CompatSpritesHelper.addOptional("promenade:stripped_sakura_log", "_side", "promenade:block/sakura/stripped_log/side");
        CompatSpritesHelper.addOptional("promenade:stripped_sakura_log", "_top", "promenade:block/sakura/stripped_log/top");
        CompatSpritesHelper.addOptional("promenade:dark_amaranth_log", "_side", "promenade:block/dark_amaranth/log/side");
        CompatSpritesHelper.addOptional("promenade:dark_amaranth_log", "_top", "promenade:block/dark_amaranth/log/top");
        CompatSpritesHelper.addOptional("promenade:stripped_dark_amaranth_log", "_side", "promenade:block/dark_amaranth/stripped_log/side");
        CompatSpritesHelper.addOptional("promenade:stripped_dark_amaranth_log", "_top", "promenade:block/dark_amaranth/stripped_log/top");
        CompatSpritesHelper.addOptional("promenade:palm_log", "_side", "promenade:block/palm/log/side");
        CompatSpritesHelper.addOptional("promenade:palm_log", "_top", "promenade:block/palm/log/top");
        CompatSpritesHelper.addOptional("promenade:stripped_palm_log", "_side", "promenade:block/palm/stripped_log/side");
        CompatSpritesHelper.addOptional("promenade:stripped_palm_log", "_top", "promenade:block/palm/stripped_log/top");
        CompatSpritesHelper.addOptional("promenade:maple_log", "_side", "promenade:block/maple/log/side");
        CompatSpritesHelper.addOptional("promenade:maple_log", "_top", "promenade:block/maple/log/top");
        CompatSpritesHelper.addOptional("promenade:stripped_maple_log", "_side", "promenade:block/maple/stripped_log/side");
        CompatSpritesHelper.addOptional("promenade:stripped_maple_log", "_top", "promenade:block/maple/stripped_log/top");
        CompatSpritesHelper.addOptional("promenade:sakura_planks", "all", "promenade:block/sakura/planks");
        CompatSpritesHelper.addOptional("promenade:dark_amaranth_planks", "all", "promenade:block/dark_amaranth/planks");
        CompatSpritesHelper.addOptional("promenade:palm_planks", "all", "promenade:block/palm/planks");
        CompatSpritesHelper.addOptional("promenade:maple_planks", "all", "promenade:block/maple/planks");
        CompatSpritesHelper.addOptional("simplemango:mango_log", "_top", "simplemango:block/mango_log_horizontal");
        CompatSpritesHelper.addOptional("rainbowoaks:rainbow_leaves", "_leaves", "minecraft:block/oak_leaves");
        CompatSpritesHelper.addOptional("culturaldelights:fruiting_avocado_leaves", "_leaves", "culturaldelights:block/fruiting_avocado_leaves_0");
        CompatSpritesHelper.addOptional("autumnity:red_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        CompatSpritesHelper.addOptional("autumnity:orange_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        CompatSpritesHelper.addOptional("autumnity:yellow_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        CompatSpritesHelper.addOptional("blue_skies:comet_leaves", "_leaves", "blue_skies:block/leaves/comet_leaves_grown");
        CompatSpritesHelper.addOptional("aether_redux:azure_fieldsproot_leaves", "_leaves", "aether_redux:block/natural/fieldsproot_leaves");
        CompatSpritesHelper.addOptional("integrateddynamics:menril_leaves", "_leaves", "integrateddynamics:block/menril_leaves_fancy");
        CompatSpritesHelper.addOptional("malum:budding_soulwood_leaves", "_leaves", "malum:block/soulwood/budding_soulwood_leaves");
        CompatSpritesHelper.addOptional("malum:azure_runewood_leaves", "_leaves", "malum:block/runewood/azure_runewood_leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:aspen_leaves", "_leaves", "biomeswevegone:block/aspen/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:baobab_leaves", "_leaves", "biomeswevegone:block/baobab/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:blue_enchanted_leaves", "_leaves", "biomeswevegone:block/blue_enchanted/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:cika_leaves", "_leaves", "biomeswevegone:block/cika/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:cypress_leaves", "_leaves", "biomeswevegone:block/cypress/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:ebony_leaves", "_leaves", "biomeswevegone:block/ebony/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:fir_leaves", "_leaves", "biomeswevegone:block/fir/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:green_enchanted_leaves", "_leaves", "biomeswevegone:block/green_enchanted/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:holly_leaves", "_leaves", "biomeswevegone:block/holly/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:ironwood_leaves", "_leaves", "biomeswevegone:block/ironwood/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:jacaranda_leaves", "_leaves", "biomeswevegone:block/jacaranda/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:mahongany_leaves", "_leaves", "biomeswevegone:block/mahongany/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:maple_leaves", "_leaves", "biomeswevegone:block/maple/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:palm_leaves", "_leaves", "biomeswevegone:block/palm/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:palo_verde_leaves", "_leaves", "biomeswevegone:block/palo_verde/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:pine_leaves", "_leaves", "biomeswevegone:block/pine/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:rainbow_eucalyptus_leaves", "_leaves", "biomeswevegone:block/rainbow_eucalyptus/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:redwood_leaves", "_leaves", "biomeswevegone:block/redwood/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:skyris_leaves", "_leaves", "biomeswevegone:block/skyris/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:white_mangrove_leaves", "_leaves", "biomeswevegone:block/white_mangrove/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:willow_leaves", "_leaves", "biomeswevegone:block/willow/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:witch_hazel_leaves", "_leaves", "biomeswevegone:block/witch_hazel/leaves");
        CompatSpritesHelper.addOptional("biomeswevegone:zelkova_leaves", "_leaves", "biomeswevegone:block/zelkova/leaves");
        CompatSpritesHelper.addOptional("eternal_tales:khagris_log", "_side", "eternal_tales:block/khagris_log_new");
        CompatSpritesHelper.addOptional("eternal_tales:khagris_log", "_top", "eternal_tales:block/edemlogtop");
        CompatSpritesHelper.addOptional("eternal_tales:stripped_khagris_log", "_side", "eternal_tales:block/khagris_log_stripped_new");
        CompatSpritesHelper.addOptional("eternal_tales:stripped_khagris_log", "_top", "eternal_tales:block/khagris_log_stripped_top_new");
        CompatSpritesHelper.addOptional("eternal_tales:purgatorium_log", "_side", "eternal_tales:block/purgatorium_log_new");
        CompatSpritesHelper.addOptional("eternal_tales:purgatorium_log", "_top", "eternal_tales:block/purglogtop");
        CompatSpritesHelper.addOptional("eternal_tales:purgatorium_stripped_log", "_side", "eternal_tales:block/purgatorium_log_stripped_new");
        CompatSpritesHelper.addOptional("eternal_tales:purgatorium_stripped_log", "_top", "eternal_tales:block/purgatorium_log_stripped_top_new");
        CompatSpritesHelper.addOptional("eternal_tales:petrified_log", "_side", "eternal_tales:block/petrifiedlogside");
        CompatSpritesHelper.addOptional("eternal_tales:petrified_log", "_top", "eternal_tales:block/petrifiedlogtop");
        CompatSpritesHelper.addOptional("eternal_tales:stripped_petrified_log", "_side", "eternal_tales:block/petrifiedlogsidestripped");
        CompatSpritesHelper.addOptional("eternal_tales:stripped_petrified_log", "_top", "eternal_tales:block/petrifiedlogstrippedtop");
        CompatSpritesHelper.addOptional("eternal_tales:mandarin_orange_log", "_side", "eternal_tales:block/mandarinlog");
        CompatSpritesHelper.addOptional("eternal_tales:mandarin_orange_log", "_top", "eternal_tales:block/mandarinlogtop");
        CompatSpritesHelper.addOptional("eternal_tales:comets_log", "_side", "eternal_tales:block/comets_log_new");
        CompatSpritesHelper.addOptional("eternal_tales:comets_log", "_top", "eternal_tales:block/cometswoodtop");
        CompatSpritesHelper.addOptional("eternal_tales:striped_comets_log", "_side", "eternal_tales:block/comets_log_stripped_new");
        CompatSpritesHelper.addOptional("eternal_tales:striped_comets_log", "_top", "eternal_tales:block/comets_log_stripped_top_new");
        CompatSpritesHelper.addOptional("eternal_tales:carved_pure_wood", "_side", "eternal_tales:block/pure_log_carved_side");
        CompatSpritesHelper.addOptional("eternal_tales:carved_pure_wood", "_top", "eternal_tales:block/pure_log_carved_top");
        CompatSpritesHelper.addOptional("biomesoplenty:null_leaves", "_leaves", "biomesoplenty:block/null_overlay");
        CompatSpritesHelper.addOptional("biomesoplenty:snowblossom_leaves", "_leaves", "biomesoplenty:block/snowblossom_leaves");
        CompatSpritesHelper.addOptional("environmental:pink_wisteria_leaves", "_leaves", "environmental:block/pink_wisteria_leaves");
        CompatSpritesHelper.addOptional("environmental:blue_wisteria_leaves", "_leaves", "environmental:block/blue_wisteria_leaves");
        CompatSpritesHelper.addOptional("environmental:purple_wisteria_leaves", "_leaves", "environmental:block/purple_wisteria_leaves");
        CompatSpritesHelper.addOptional("environmental:white_wisteria_leaves", "_leaves", "environmental:block/white_wisteria_leaves");
        CompatSpritesHelper.addOptional("dawnoftimebuilder:waxed_oak_planks", "_side", "dawnoftimebuilder:block/waxed_oak_planks");
        CompatSpritesHelper.addOptional("dawnoftimebuilder:waxed_oak_planks", "_top", "dawnoftimebuilder:block/waxed_oak_planks");
        CompatSpritesHelper.addOptional("dawnoftimebuilder:charred_spruce_planks", "_side", "dawnoftimebuilder:block/charred_spruce_planks");
        CompatSpritesHelper.addOptional("dawnoftimebuilder:charred_spruce_planks", "_top", "dawnoftimebuilder:block/charred_spruce_planks");
        CompatSpritesHelper.addOptional("shadowlands:vellium_log", "_side", "shadowlands:block/velliumlogside");
        CompatSpritesHelper.addOptional("shadowlands:vellium_log", "_top", "shadowlands:block/log");
        CompatSpritesHelper.addOptional("shadowlands:vellium_planks", "_all", "shadowlands:block/velliumplanks");
        CompatSpritesHelper.addOptional("shadowlands:vellium_leaves", "_top", "shadowlands:block/velliumleaves");
        CompatSpritesHelper.addOptional("midnight:bogshroom_stem", "_side", "midnight:block/bogshroom_cap");
        CompatSpritesHelper.addOptional("midnight:bogshroom_stem", "_top", "midnight:block/bogshroom_cap");
        CompatSpritesHelper.addOptional("midnight:moonshroom_stem", "_side", "midnight:block/moonshroom_cap");
        CompatSpritesHelper.addOptional("midnight:moonshroom_stem", "_top", "midnight:block/moonshroom_cap");
        CompatSpritesHelper.addOptional("midnight:nightshroom_stem", "_side", "midnight:block/nightshroom_cap");
        CompatSpritesHelper.addOptional("midnight:nightshroom_stem", "_top", "midnight:block/nightshroom_cap");
        CompatSpritesHelper.addOptional("midnight:viridshroom_stem", "_side", "midnight:block/viridshroom_cap");
        CompatSpritesHelper.addOptional("midnight:viridshroom_stem", "_top", "midnight:block/viridshroom_cap");
        CompatSpritesHelper.addOptional("midnight:dewshroom_stem", "_side", "midnight:block/dewshroom_cap");
        CompatSpritesHelper.addOptional("midnight:dewshroom_stem", "_top", "midnight:block/dewshroom_cap");
        CompatSpritesHelper.addOptional("aoa3:stranglewood_log", "_side", "aoa3:block/stranglewood_log");
        CompatSpritesHelper.addOptional("aoa3:stranglewood_log", "_top", "aoa3:block/stranglewood_log_top");
        CompatSpritesHelper.addOptional("betterend:lucernia_leaves", "_leaves", "betterend:block/lucernia_leaves_1");
        CompatSpritesHelper.addOptional("betternether:nether_mushroom", "_side", "betternether:block/nether_mushroom_stem_side");
        CompatSpritesHelper.addOptional("mynethersdelight:powdery_block", "_side", "mynethersdelight:block/powdery_block");
        CompatSpritesHelper.addOptional("mynethersdelight:stripped_powdery_block", "_side", "mynethersdelight:block/stripped_powdery_block");
        CompatSpritesHelper.addOptional("piglin_ruins:ominous_stalk_block", "_side", "piglin_ruins:block/ominous_stalk_block_side");
        CompatSpritesHelper.addOptional("piglin_ruins:ominous_stalk_block", "_top", "piglin_ruins:block/ominous_stalk_block_top");
        CompatSpritesHelper.addOptional("piglin_ruins:stripped_ominous_stalk_block", "_side", "piglin_ruins:block/stripped_ominous_stalk_block_side");
        CompatSpritesHelper.addOptional("piglin_ruins:stripped_ominous_stalk_block", "_top", "piglin_ruins:block/stripped_ominous_stalk_block_top");
        CompatSpritesHelper.addOptional("unusualend:chorus_cane_block", "_side", "unusualend:block/chorus_cane_block_side");
        CompatSpritesHelper.addOptional("unusualend:chorus_cane_block", "_top", "unusualend:block/chorus_cane_block_top");
        CompatSpritesHelper.addOptional("unusualend:stripped_chorus_cane_block", "_side", "unusualend:block/stripped_chorus_cane_block_side");
        CompatSpritesHelper.addOptional("unusualend:stripped_chorus_cane_block", "_top", "unusualend:block/stripped_chorus_cane_block_top");
        CompatSpritesHelper.addOptional("ad_astra:strophar_stem", "_side", "ad_astra:block/strophar_stem");
        CompatSpritesHelper.addOptional("ad_astra:strophar_stem", "_top", "ad_astra:block/strophar_stem");
        CompatSpritesHelper.addOptional("ad_astra:aeronos_stem", "_side", "ad_astra:block/aeronos_stem");
        CompatSpritesHelper.addOptional("ad_astra:aeronos_stem", "_top", "ad_astra:block/aeronos_stem");
        CompatSpritesHelper.addOptional("terrestria:sakura_log", "_top", "terrestria:block/sakura_log_section");
        CompatSpritesHelper.addOptional("terrestria:yucca_palm_log", "_top", "terrestria:block/yucca_palm_log_section");
        CompatSpritesHelper.addOptional("terrestria:stripped_yucca_palm_log", "_top", "terrestria:block/stripped_yucca_palm_log_section");
        CompatSpritesHelper.addOptional("theabyss:rena_log", "_top", "theabyss:block/rena_log");
        CompatSpritesHelper.addOptional("theabyss:stripped_rena_log", "_top", "theabyss:block/rena_log");
        CompatSpritesHelper.addOptional("theabyss:luna_log", "_top", "theabyss:block/luna_log");
        CompatSpritesHelper.addOptional("theabyss:stripped_luna_log", "_top", "theabyss:block/luna_log");
        CompatSpritesHelper.addOptional("dreamy_cottage:strawberry_log", "_side", "dreamy_cottage:block/strawberrylogside");
        CompatSpritesHelper.addOptional("dreamy_cottage:strawberry_log", "_top", "dreamy_cottage:block/strawberrylog");
        CompatSpritesHelper.addOptional("dreamy_cottage:stripped_strawberry_log", "_side", "dreamy_cottage:block/strippedlogsidestrawberry");
        CompatSpritesHelper.addOptional("dreamy_cottage:stripped_strawberry_log", "_top", "dreamy_cottage:block/strippedlogstrawberry");
        CompatSpritesHelper.addOptional("dreamy_cottage:white_oak_log", "_side", "dreamy_cottage:block/untitled416_20240420160357_1");
        CompatSpritesHelper.addOptional("dreamy_cottage:white_oak_log", "_top", "dreamy_cottage:block/untitled416_20240420160009_1");
        CompatSpritesHelper.addOptional("dreamy_cottage:stripped_white_oak_log", "_side", "dreamy_cottage:block/strippedwhiteoakside");
        CompatSpritesHelper.addOptional("dreamy_cottage:stripped_white_oak_log", "_top", "dreamy_cottage:block/strippedwhiteoak");
        CompatSpritesHelper.addOptional("dreamy_cottage:strawberry_leaves", "_leaves", "dreamy_cottage:block/whiteoakleaves");
        CompatSpritesHelper.addOptional("dreamy_cottage:white_oak_leaves", "_leaves", "dreamy_cottage:block/whiteoakleaves");
        CompatSpritesHelper.addOptional("feywild:spring_tree_log", "_side", "feywild:block/spring_tree_wood");
        CompatSpritesHelper.addOptional("feywild:spring_tree_log", "_top", "feywild:block/spring_tree_log");
        CompatSpritesHelper.addOptional("feywild:summer_tree_log", "_side", "feywild:block/summer_tree_wood");
        CompatSpritesHelper.addOptional("feywild:summer_tree_log", "_top", "feywild:block/summer_tree_log");
        CompatSpritesHelper.addOptional("feywild:autumn_tree_log", "_side", "feywild:block/autumn_tree_wood");
        CompatSpritesHelper.addOptional("feywild:autumn_tree_log", "_top", "feywild:block/autumn_tree_log");
        CompatSpritesHelper.addOptional("feywild:winter_tree_log", "_side", "feywild:block/winter_tree_wood");
        CompatSpritesHelper.addOptional("feywild:winter_tree_log", "_top", "feywild:block/winter_tree_log");
        CompatSpritesHelper.addOptional("feywild:blossom_tree_log", "_side", "feywild:block/blossom_tree_wood");
        CompatSpritesHelper.addOptional("feywild:blossom_tree_log", "_top", "feywild:block/blossom_tree_log");
        CompatSpritesHelper.addOptional("feywild:hexen_tree_log", "_side", "feywild:block/hexen_tree_wood");
        CompatSpritesHelper.addOptional("feywild:hexen_tree_log", "_top", "feywild:block/hexen_tree_log");
        CompatSpritesHelper.addOptional("born_in_chaos_v1:scorched_log", "_side", "born_in_chaos_v1:block/brievno");
        CompatSpritesHelper.addOptional("born_in_chaos_v1:scorched_log", "_top", "born_in_chaos_v1:block/brievnovierkh1");
        CompatSpritesHelper.addOptional("born_in_chaos_v1:stripped_scorched_log", "_side", "born_in_chaos_v1:block/obdreve");
        CompatSpritesHelper.addOptional("born_in_chaos_v1:stripped_scorched_log", "_top", "born_in_chaos_v1:block/obtes");
        CompatSpritesHelper.addOptional("born_in_chaos_v1:scorched_planks", "_planks", "born_in_chaos_v1:block/opdosk");
        CompatSpritesHelper.addOptional("nue:dragon_stem", "_side", "nue:block/dragonstem");
        CompatSpritesHelper.addOptional("nue:dragon_stem", "_top", "nue:block/dragonstemtop");
        CompatSpritesHelper.addOptional("nue:stripped_dragon_stem", "_side", "nue:block/strippeddragonstem");
        CompatSpritesHelper.addOptional("nue:stripped_dragon_stem", "_top", "nue:block/strippeddragonstemtop");
        CompatSpritesHelper.addOptional("nue:elder_stem", "_side", "nue:block/elderstem");
        CompatSpritesHelper.addOptional("nue:elder_stem", "_top", "nue:block/elderstemtop");
        CompatSpritesHelper.addOptional("nue:stripped_elder_stem", "_side", "nue:block/strippedelderstem");
        CompatSpritesHelper.addOptional("nue:stripped_elder_stem", "_top", "nue:block/strippedelderstemtop");
        CompatSpritesHelper.addOptional("nue:frosted_stem", "_side", "nue:block/frostedstem");
        CompatSpritesHelper.addOptional("nue:frosted_stem", "_top", "nue:block/frostedstem2");
        CompatSpritesHelper.addOptional("nue:stripped_frosted_stem", "_side", "nue:block/strippedfrozenstem");
        CompatSpritesHelper.addOptional("nue:stripped_frosted_stem", "_top", "nue:block/strippedfrozenstemtop");
        CompatSpritesHelper.addOptional("fruitfulfun:apple_leaves", "_leaves", "minecraft:block/oak_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:cherry_leaves", "_leaves", "fruitfulfun:block/cherry_leaves_2");
        CompatSpritesHelper.addOptional("fruitfulfun:citron_leaves", "_leaves", "fruitfulfun:block/citron_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:grapefruit_leaves", "_leaves", "fruitfulfun:block/grapefruit_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:lemon_leaves", "_leaves", "fruitfulfun:block/lemon_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:lime_leaves", "_leaves", "fruitfulfun:block/lime_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:orange_leaves", "_leaves", "fruitfulfun:block/orange_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:pomegranate_leaves", "_leaves", "fruitfulfun:block/pomegranate_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:pomelo_leaves", "_leaves", "fruitfulfun:block/pomelo_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:redlove_leaves", "_leaves", "fruitfulfun:block/redlove_leaves");
        CompatSpritesHelper.addOptional("fruitfulfun:tangerine_leaves", "_leaves", "fruitfulfun:block/tangerine_leaves");
        CompatSpritesHelper.addOptional("extendedmushrooms:glowshroom_stem", "_top", "extendedmushrooms:block/glowshroom_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:glowshroom_stem_stripped", "_top", "extendedmushrooms:block/glowshroom_stem_stripped");
        CompatSpritesHelper.addOptional("extendedmushrooms:poisonous_mushroom_stem", "_top", "extendedmushrooms:block/poisonous_mushroom_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:poisonous_mushroom_stem_stripped", "_top", "extendedmushrooms:block/poisonous_mushroom_stem_stripped");
        CompatSpritesHelper.addOptional("extendedmushrooms:stripped_mushroom_stem", "_side", "extendedmushrooms:block/stripped_mushroom_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:stripped_mushroom_stem", "_top", "extendedmushrooms:block/stripped_mushroom_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:honey_fungus_stem", "_side", "extendedmushrooms:block/honey_fungus_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:honey_fungus_stem", "_top", "extendedmushrooms:block/honey_fungus_stem");
        CompatSpritesHelper.addOptional("extendedmushrooms:honey_fungus_stem_stripped", "_side", "extendedmushrooms:block/honey_fungus_stem_stripped");
        CompatSpritesHelper.addOptional("extendedmushrooms:honey_fungus_stem_stripped", "_top", "extendedmushrooms:block/honey_fungus_stem_stripped");
        CompatSpritesHelper.addOptional("vinery:apple_leaves", "_leaves", "vinery:block/apple_leaves_0");
        CompatSpritesHelper.addOptional("vinery:dark_cherry", "_leaves", "vinery:block/dark_cherry_leaves");
        CompatSpritesHelper.addOptional("twilightforest:beanstalk_leaves", "_leaves", "minecraft:block/azalea_leaves");
        CompatSpritesHelper.addOptional("twilightforest:thorn_leaves", "_leaves", "minecraft:block/oak_leaves");
        CompatSpritesHelper.addOptional("regions_unexplored:eucalyptus_log", "_side", "everycomp:block/regions_unexplored/eucalyptus_log");
        CompatSpritesHelper.addOptional("regions_unexplored:alpha_leaves", "_leaves", "regions_unexplored:block/alpha_oak_leaves");
        CompatSpritesHelper.addOptional("regions_unexplored:apple_oak_leaves", "_leaves", "regions_unexplored:block/apple_oak_leaves_stage_0");
        CompatSpritesHelper.addOptional("regions_unexplored:flowering_leaves", "_leaves", "regions_unexplored:item/flowering_leaves");
        CompatSpritesHelper.addOptional("regions_unexplored:palm_leaves", "_leaves", "regions_unexplored:block/palm_leaves_side");
        CompatSpritesHelper.addOptional("regions_unexplored:enchanted_birch_leaves", "_leaves", "regions_unexplored:item/enchanted_birch_leaves");
        CompatSpritesHelper.addOptional("regions_unexplored:silver_birch_leaves", "_leaves", "regions_unexplored:item/silver_birch_leaves");
        CompatSpritesHelper.addOptional("regions_unexplored:small_oak_leaves", "_leaves", "minecraft:block/oak_leaves");
        CompatSpritesHelper.addOptional("endlessbiomes:twisted_stem", "_side", "endlessbiomes:block/twistedlogsidetest");
        CompatSpritesHelper.addOptional("endlessbiomes:twisted_stem", "_top", "endlessbiomes:block/twistedlogtoptest");
        CompatSpritesHelper.addOptional("endlessbiomes:stripped_twisted_stem", "_side", "endlessbiomes:block/twistedstrippedlogsidetest");
        CompatSpritesHelper.addOptional("endlessbiomes:stripped_twisted_stem", "_top", "endlessbiomes:block/twistedstrippedlogtoptest");
        CompatSpritesHelper.addOptional("endlessbiomes:penumbra_stem", "_side", "endlessbiomes:block/penumbrallogsidenewest");
        CompatSpritesHelper.addOptional("endlessbiomes:penumbra_stem", "_top", "endlessbiomes:block/penumbrallogtopnewest");
        CompatSpritesHelper.addOptional("endlessbiomes:stripped_penumbra_stem", "_side", "endlessbiomes:block/strippedpenumbralogsidenewest");
        CompatSpritesHelper.addOptional("endlessbiomes:stripped_penumbra_stem", "_top", "endlessbiomes:block/strippedpenumbralogtopnewest");
        CompatSpritesHelper.addOptional("gardens_of_the_dead:whistlecane", "_side", "gardens_of_the_dead:block/whistlecane_block");
        CompatSpritesHelper.addOptional("gardens_of_the_dead:whistlecane", "_top", "gardens_of_the_dead:block/whistlecane_block_top");
        CompatSpritesHelper.addOptional("gardens_of_the_dead:stripped_soulblight_stem", "_side", "gardens_of_the_dead:block/stripped_soulblight_stem");
        CompatSpritesHelper.addOptional("gardens_of_the_dead:stripped_soulblight_stem", "_top", "gardens_of_the_dead:block/stripped_soulblight_stem_top");
        CompatSpritesHelper.addOptional("cataclysm:chorus_stem", "_side", "cataclysm:block/chorus_stem");
        CompatSpritesHelper.addOptional("cataclysm:chorus_stem", "_top", "cataclysm:block/chorus_stem");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:ice_blue_topaz_log", "_side", "pfw_aesthetic_gems:block/ice_blue_topaz_log");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:ice_blue_topaz_log", "_top", "pfw_aesthetic_gems:block/ice_blue_topaz_log_top");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:stripped_ice_blue_topaz_log", "_side", "pfw_aesthetic_gems:block/stripped_ice_blue_topaz_log");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:stripped_ice_blue_topaz_log", "_top", "pfw_aesthetic_gems:block/stripped_ice_blue_topaz_log_top");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:pink_topaz_log", "_side", "pfw_aesthetic_gems:block/pink_topaz_log");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:pink_topaz_log", "_top", "pfw_aesthetic_gems:block/pink_topaz_log_top");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:stripped_pink_topaz_log", "_side", "pfw_aesthetic_gems:block/stripped_pink_topaz_log");
        CompatSpritesHelper.addOptional("pfw_aesthetic_gems:stripped_pink_topaz_log", "_top", "pfw_aesthetic_gems:block/stripped_pink_topaz_log_top");
    }

    private static void addOptional(String blockId, String textureId, String texturePath) {
        BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(blockId)).ifPresent(b -> TextureCache.registerSpecialTextureForBlock((ItemLike)b, (String)textureId, (ResourceLocation)new ResourceLocation(texturePath)));
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceOakLeaves(BlockTypeResTransformer<T> t) {
        return t.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("_snow") && !s.contains("snow_") && !s.contains("snowy_"));
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceOakPlanks(BlockTypeResTransformer<T> t) {
        return t.replaceWithTextureFromChild("minecraft:block/oak_planks", "planks");
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceOakBark(BlockTypeResTransformer<T> t) {
        return t.replaceWithTextureFromChild("minecraft:block/oak_log", "log", LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/oak_log_top", "log", LOOKS_LIKE_TOP_LOG_TEXTURE);
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceOakStripped(BlockTypeResTransformer<T> t) {
        return t.replaceWithTextureFromChild("minecraft:block/stripped_oak_log", "stripped_log", LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/stripped_oak_log_top", "stripped_log", LOOKS_LIKE_TOP_LOG_TEXTURE);
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceWoodTextures(BlockTypeResTransformer<T> t, WoodType woodType) {
        String n = woodType.getTypeName();
        return t.replaceWithTextureFromChild("minecraft:block/" + n + "_planks", "planks").replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log", "stripped_log", LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log_top", "stripped_log", LOOKS_LIKE_TOP_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/" + n + "_log", "log", LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/" + n + "_log_top", "log", LOOKS_LIKE_TOP_LOG_TEXTURE);
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> replaceLeavesTextures(BlockTypeResTransformer<T> t, LeavesType woodType) {
        String n = woodType.getTypeName();
        return t.replaceWithTextureFromChild("minecraft:block/" + n + "_leaves", "leaves", LOOKS_LIKE_LEAF_TEXTURE).replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log", l -> CompatSpritesHelper.wfl(l, "stripped_log"), LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log_top", l -> CompatSpritesHelper.wfl(l, "stripped_log"), LOOKS_LIKE_TOP_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/" + n + "_log", l -> CompatSpritesHelper.wfl(l, "log"), LOOKS_LIKE_SIDE_LOG_TEXTURE).replaceWithTextureFromChild("minecraft:block/" + n + "_log_top", l -> CompatSpritesHelper.wfl(l, "log"), LOOKS_LIKE_TOP_LOG_TEXTURE);
    }

    @Nullable
    private static <T extends BlockType> ItemLike wfl(T t, String s) {
        LeavesType l;
        if (t instanceof LeavesType && (l = (LeavesType)t).getAssociatedWoodType() != null) {
            ItemLike il;
            Object c = l.getAssociatedWoodType().getChild(s);
            return c instanceof ItemLike ? (il = (ItemLike)c) : null;
        }
        return null;
    }

    public static void maybePostProcessWoodTexture(WoodType wood, ResourceLocation newId, ResourceManager manager, TextureImage textureSupplier, TextureInfo textureInfo) {
        if (wood == FLOWERING_AZALEA.get()) {
            CompatSpritesHelper.flowerAzalea(textureSupplier, manager, newId, textureInfo);
        } else if (wood == BRIMWOOD.get()) {
            CompatSpritesHelper.brimwoodGlow(textureSupplier, manager, newId, textureInfo);
        } else if (wood == STRANGEWOOD.get()) {
            CompatSpritesHelper.strangewoodPattern(textureSupplier, manager);
        }
    }

    private static void flowerAzalea(TextureImage image, ResourceManager manager, ResourceLocation textureId, TextureInfo textureInfo) {
        if (image.imageWidth() <= 32 && image.imageHeight() <= 32) {
            try (TextureImage flowerOverLay = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)CompatSpritesHelper.AZALEA.get().planks));){
                Respriter respriter = Objects.nonNull(textureInfo.mask()) ? Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)textureInfo.mask())) : Respriter.of((TextureImage)image);
                try (TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);){
                    if (!textureInfo.texture().toString().matches("boatload:item/(oak_furnace|large_oak)_boat") && !textureInfo.texture().toString().matches("chipped:(item/oak_door|block/torch)/\\w+")) {
                        TextureOps.applyOverlayOnExisting((TextureImage)image, (TextureImage[])new TextureImage[]{temp, flowerOverLay});
                    }
                }
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("Failed to apply the flowering overlay to {}: {}", (Object)textureId, (Object)e);
            }
        }
    }

    private static void brimwoodGlow(TextureImage image, ResourceManager manager, ResourceLocation textureId, TextureInfo textureInfo) {
        block21: {
            try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_planks"));){
                String toString = textureId.toString();
                Respriter respriter = Objects.nonNull(textureInfo.mask()) ? Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)textureInfo.mask())) : Respriter.of((TextureImage)image);
                try (TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);){
                    if (toString.contains("stairs") || toString.contains("planks") || toString.contains("slab") || toString.contains("beehive") || toString.contains("composter_bottom") || toString.contains("composter_side") || toString.contains("lectern_side") || toString.contains("lectern_top") || toString.contains("bookshelf_side") || toString.contains("bookshelf_top")) {
                        try (TextureImage lavaOverlay = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_planks_lava"));){
                            TextureOps.applyOverlayOnExisting((TextureImage)image, (TextureImage[])new TextureImage[]{temp, lavaOverlay});
                            break block21;
                        }
                    }
                    TextureOps.applyOverlayOnExisting((TextureImage)image, (TextureImage[])new TextureImage[]{temp});
                }
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to process {}'s texture: {}", (Object)textureId, (Object)e);
            }
        }
    }

    private static void strangewoodPattern(TextureImage image, ResourceManager manager) {
        try (TextureImage vineOverlay = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("aoa3:block/stranglewood_log_vine"));
             TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)CompatSpritesHelper.STRANGEWOOD.get().log, LOOKS_LIKE_SIDE_LOG_TEXTURE));){
            Respriter respriter = Respriter.of((TextureImage)image);
            try (TextureImage temp = respriter.recolorWithAnimationOf(logTexture);){
                TextureOps.applyOverlayOnExisting((TextureImage)image, (TextureImage[])new TextureImage[]{temp, vineOverlay});
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.warn("Failed to apply vine overlay for strangewood texture: {}", (Object)String.valueOf(e));
        }
    }

    public static void createSmallLogTopTexture(TextureImage original, TextureImage canvas) {
        TextureCollager collager = TextureCollager.builder((int)16, (int)16, (int)16, (int)16).copyFrom(5, 5, 6, 6).to(2, 2).copyFrom(14, 1, 2, 7).to(8, 1).copyFrom(1, 14, 7, 2).to(1, 8).copyFrom(14, 14, 2, 2).to(8, 8).build();
        collager.apply(original, canvas);
    }
}

