/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe.jei;

import alexthw.ars_elemental.recipe.ElementalArmorRecipe;
import alexthw.ars_elemental.recipe.jei.JeiArsExtraPlugin;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class ElementalUpgradeRecipeCategory
extends EnchantingApparatusRecipeCategory<ElementalArmorRecipe> {
    public ElementalUpgradeRecipeCategory(IGuiHelper helper) {
        super(helper);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ElementalArmorRecipe recipe, IFocusGroup focuses) {
        MultiInputCategory.MultiProvider provider = (MultiInputCategory.MultiProvider)this.multiProvider.apply(recipe);
        List inputs = provider.input();
        double angleBetweenEach = 360.0 / (double)inputs.size();
        if (provider.optionalCenter() != null) {
            ItemStack[] stacks;
            for (ItemStack stack : stacks = provider.optionalCenter().m_43908_()) {
                IPerkHolder iPerkHolder;
                IPerkProvider perkProvider = PerkRegistry.getPerkProvider((Item)stack.m_41720_());
                if (perkProvider == null || !((iPerkHolder = perkProvider.getPerkHolder((Object)stack)) instanceof ArmorPerkHolder)) continue;
                ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)iPerkHolder;
                armorPerkHolder.setTier(2);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 45).addItemStacks(List.of(stacks));
        }
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.f_82470_, (int)this.point.f_82471_).addIngredients(input);
            this.point = ElementalUpgradeRecipeCategory.rotatePointAbout((Vec2)this.point, (Vec2)this.center, (double)angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 10).addItemStacks(Collections.singletonList(provider.output()));
    }

    public Component getTitle() {
        return Component.m_237115_((String)"ars_nouveau.armor_upgrade");
    }

    public RecipeType<ElementalArmorRecipe> getRecipeType() {
        return JeiArsExtraPlugin.ELEMENTAL_ARMOR_TYPE;
    }

    public void draw(ElementalArmorRecipe recipe, @NotNull IRecipeSlotsView slotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font renderer = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280614_(renderer, (Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{1 + recipe.tier}), 0, 0, 10, false);
        if (recipe.consumesSource()) {
            guiGraphics.m_280614_(renderer, (Component)Component.m_237110_((String)"ars_nouveau.source", (Object[])new Object[]{recipe.sourceCost}), 0, 100, 10, false);
        }
    }
}

