/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.tooltip;

import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.config.RangedInteger;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TooltipHelper {
    public static final ChatFormatting DEFAULT_FORMAT = ChatFormatting.GRAY;

    public static MutableComponent asFormula(Object base, Object bonus) {
        return TextHelper.translatable((String)"majruszsaccessories.items.formula", (Object[])new Object[]{base, bonus}).m_130940_(DEFAULT_FORMAT);
    }

    public static MutableComponent asRange(Object base, Object bonus) {
        return TextHelper.translatable((String)"majruszsaccessories.items.range", (Object[])new Object[]{base, bonus}).m_130940_(DEFAULT_FORMAT);
    }

    public static IntegerTooltip asValue(RangedInteger value) {
        return new IntegerTooltip(value);
    }

    public static FloatTooltip asValue(RangedFloat value) {
        return new FloatTooltip(value);
    }

    public static IntegerTooltip asFixedValue(RangedInteger value) {
        return new IntegerTooltip(value).bonusMultiplier(0);
    }

    public static FloatTooltip asFixedValue(RangedFloat value) {
        return new FloatTooltip(value).bonusMultiplier(0.0f);
    }

    public static PercentTooltip asPercent(RangedFloat value) {
        return new PercentTooltip(value);
    }

    public static PercentTooltip asFixedPercent(RangedFloat value) {
        return new PercentTooltip(value).bonusMultiplier(0.0f);
    }

    public static ITooltipProvider asBooster(final Supplier<BoosterItem> item) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                if (!holder.isValid()) {
                    return TextHelper.literal((String)"");
                }
                return TextHelper.translatable((String)"majruszsaccessories.items.booster_name", (Object[])new Object[]{((BoosterItem)((Object)item.get())).m_41466_()}).m_130940_(((BoosterItem)((Object)item.get())).m_41460_((ItemStack)ItemStack.f_41583_).f_43022_).m_130946_(" ");
            }
        };
    }

    public static ITooltipProvider asItem(final Supplier<Item> item) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                return ((Item)item.get()).m_41466_().m_6881_();
            }
        };
    }

    public static ITooltipProvider asEntity(final Supplier<EntityType<?>> type) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                return ((EntityType)type.get()).m_20676_().m_6881_();
            }
        };
    }

    public static class IntegerTooltip
    implements ITooltipProvider {
        private final RangedInteger value;
        private int bonusMultiplier = 1;
        private int valueMultiplier = 1;

        IntegerTooltip(RangedInteger value) {
            this.value = value;
        }

        @Override
        public MutableComponent getTooltip(AccessoryHolder holder) {
            int bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            int defaultValue = this.value.get() * this.valueMultiplier;
            int diff = bonusValue - defaultValue;
            return TextHelper.literal((String)"%d".formatted(bonusValue)).m_130940_(diff != 0 ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
            int defaultValue;
            int bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            int diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            MutableComponent component = diff != 0 ? TextHelper.literal((String)TextHelper.signed((int)diff)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(defaultValue, component.m_130940_(holder.getBonusFormatting()));
        }

        @Override
        public MutableComponent getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            int minValue = AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            int maxValue = AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            int defaultValue = this.value.get() * this.valueMultiplier;
            MutableComponent minComponent = TextHelper.literal((String)("" + minValue)).m_130940_(minValue != defaultValue ? AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()) : DEFAULT_FORMAT);
            if (minValue != maxValue) {
                MutableComponent maxComponent = TextHelper.literal((String)("" + maxValue)).m_130940_(maxValue != defaultValue ? AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()) : DEFAULT_FORMAT);
                return TooltipHelper.asRange(minComponent, maxComponent);
            }
            return minComponent;
        }

        public IntegerTooltip bonusMultiplier(int multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public IntegerTooltip valueMultiplier(int multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }
    }

    public static class FloatTooltip
    implements ITooltipProvider {
        private final RangedFloat value;
        private float bonusMultiplier = 1.0f;
        private float valueMultiplier = 1.0f;
        private float diffMargin = 0.001f;
        private boolean isScaledOnlyOnDetailed = false;
        private int scale = 2;

        FloatTooltip(RangedFloat value) {
            this.value = value;
        }

        @Override
        public MutableComponent getTooltip(AccessoryHolder holder) {
            int scale = this.isScaledOnlyOnDetailed ? 0 : this.scale;
            float bonusValue = FloatTooltip.getScaled(holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float defaultValue = FloatTooltip.getScaled(this.value.get() * this.valueMultiplier, scale);
            float diff = bonusValue - defaultValue;
            return TextHelper.literal((String)TextHelper.minPrecision((float)bonusValue, (int)scale)).m_130940_(Math.abs(diff) >= this.diffMargin ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
            float defaultValue;
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            MutableComponent component = Math.abs(diff) >= this.diffMargin ? TextHelper.literal((String)TextHelper.signed((float)diff, (int)this.scale)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(TextHelper.minPrecision((float)defaultValue, (int)this.scale), component.m_130940_(holder.getBonusFormatting()));
        }

        @Override
        public MutableComponent getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            int scale = this.isScaledOnlyOnDetailed ? 0 : this.scale;
            float minValue = FloatTooltip.getScaled(AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float maxValue = FloatTooltip.getScaled(AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float defaultValue = FloatTooltip.getScaled(this.value.get() * this.valueMultiplier, scale);
            MutableComponent minComponent = TextHelper.literal((String)TextHelper.minPrecision((float)minValue, (int)this.scale)).m_130940_(Math.abs(minValue - defaultValue) >= this.diffMargin ? AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()) : DEFAULT_FORMAT);
            if (Math.abs(maxValue - minValue) >= this.diffMargin) {
                MutableComponent maxComponent = TextHelper.literal((String)TextHelper.minPrecision((float)maxValue, (int)this.scale)).m_130940_(Math.abs(maxValue - defaultValue) >= this.diffMargin ? AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()) : DEFAULT_FORMAT);
                return TooltipHelper.asRange(minComponent, maxComponent);
            }
            return minComponent;
        }

        public FloatTooltip bonusMultiplier(float multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public FloatTooltip valueMultiplier(float multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }

        public FloatTooltip scale(int scale) {
            this.scale = scale;
            this.diffMargin = (float)Math.pow(0.1, scale + 2);
            return this;
        }

        public FloatTooltip scaleOnlyOnDetailed() {
            this.isScaledOnlyOnDetailed = true;
            return this;
        }

        private static float getScaled(float value, int scale) {
            return new BigDecimal(value).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().floatValue();
        }
    }

    public static class PercentTooltip
    implements ITooltipProvider {
        private final RangedFloat value;
        private float bonusMultiplier = 1.0f;
        private float valueMultiplier = 1.0f;
        private float diffMargin = 0.001f;
        private int scale = 2;

        PercentTooltip(RangedFloat value) {
            this.value = value;
        }

        @Override
        public MutableComponent getTooltip(AccessoryHolder holder) {
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float defaultValue = this.value.get() * this.valueMultiplier;
            float diff = bonusValue - defaultValue;
            return TextHelper.literal((String)TextHelper.percent((float)bonusValue, (int)this.scale)).m_130940_(Math.abs(diff) >= this.diffMargin ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
            float defaultValue;
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            MutableComponent component = Math.abs(diff) >= this.diffMargin ? TextHelper.literal((String)TextHelper.signedPercent((float)diff, (int)this.scale)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(TextHelper.percent((float)defaultValue, (int)this.scale), component.m_130940_(holder.getBonusFormatting()));
        }

        @Override
        public MutableComponent getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            float minValue = AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            float maxValue = AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            MutableComponent minComponent = TextHelper.literal((String)TextHelper.percent((float)minValue, (int)this.scale)).m_130940_(AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()));
            if (Math.abs(maxValue - minValue) >= this.diffMargin) {
                return TooltipHelper.asRange(minComponent, TextHelper.literal((String)TextHelper.percent((float)maxValue, (int)this.scale)).m_130940_(AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue())));
            }
            return minComponent;
        }

        public PercentTooltip bonusMultiplier(float multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public PercentTooltip valueMultiplier(float multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }

        public PercentTooltip scale(int scale) {
            this.scale = scale;
            this.diffMargin = (float)Math.pow(0.1, scale + 2);
            return this;
        }
    }
}

