/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.particles;

import com.majruszlibrary.client.CustomParticle;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsaccessories.particles.BonusParticleType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BonusParticle
extends CustomParticle {
    private final SpriteSet spriteSet;

    public BonusParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.xdFormula = xd -> xd * 0.8;
        this.ydFormula = yd -> yd * 0.8;
        this.zdFormula = zd -> zd * 0.8;
        this.f_107225_ = TimeHelper.toTicks((double)Random.nextFloat((float)1.8f, (float)2.4f));
        this.f_107224_ = 0;
        this.scaleFormula = lifetime -> Float.valueOf(0.5f);
        this.m_108339_(this.spriteSet);
    }

    public void update(BonusParticleType.Options options) {
        int color = options.color;
        float colorRatio = Random.nextFloat((float)0.8f, (float)1.0f);
        this.m_107253_((float)(color >> 16 & 0xFF) / 255.0f * colorRatio, (float)(color >> 8 & 0xFF) / 255.0f * colorRatio, (float)(color & 0xFF) / 255.0f * colorRatio);
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.f_107220_) {
            this.m_108337_(this.spriteSet.m_5819_(Math.min(8 * this.f_107224_, this.f_107225_), this.f_107225_));
        }
        this.m_107271_(Math.min(1.0f, 3.0f * (1.0f - (float)this.f_107224_ / (float)this.f_107225_)));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends CustomParticle.Factory<BonusParticle, BonusParticleType.Options> {
        public Factory(SpriteSet sprite) {
            super(sprite, BonusParticle::new, BonusParticle::update);
        }
    }
}

