/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.listeners;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.config.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class BoosterDropper {
    private ResourceLocation lootTable = MajruszsAccessories.HELPER.getLocation("gameplay/nether_accessories");
    private float chestChance = 0.1f;
    private float mobChance = 0.005f;

    public BoosterDropper() {
        OnLootGenerated.listen(this::spawnBoosterInChest).addCondition(Condition.isLogicalServer()).addCondition(Condition.hasLevel()).addCondition(Condition.chance(() -> Float.valueOf(this.chestChance))).addCondition(Condition.predicate(data -> data.origin != null)).addCondition(Condition.predicate(data -> BlockHelper.getEntity((Level)data.getLevel(), (Vec3)data.origin) instanceof RandomizableContainerBlockEntity)).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer)).addCondition(Condition.predicate(data -> EntityHelper.isIn((Entity)data.entity, (ResourceKey)Level.f_46429_)));
        OnLootGenerated.listen(this::dropBoosterFromMonster).addCondition(Condition.isLogicalServer()).addCondition(Condition.hasLevel()).addCondition(Condition.chance(() -> Float.valueOf(this.mobChance))).addCondition(Condition.predicate(data -> data.entity != null)).addCondition(Condition.predicate(data -> data.killer != null)).addCondition(Condition.predicate(data -> data.lastDamagePlayer != null)).addCondition(Condition.predicate(data -> EntityHelper.isIn((Entity)data.killer, (ResourceKey)Level.f_46429_)));
        Serializables.get(Config.Boosters.class).define("loot_table", Reader.location(), s -> this.lootTable, (s, v) -> {
            this.lootTable = v;
        }).define("nether_chest_chance", Reader.number(), s -> Float.valueOf(this.chestChance), (s, v) -> {
            this.chestChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("nether_mob_chance", Reader.number(), s -> Float.valueOf(this.mobChance), (s, v) -> {
            this.mobChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void spawnBoosterInChest(OnLootGenerated data) {
        this.addBooster(data, data.entity);
    }

    private void dropBoosterFromMonster(OnLootGenerated data) {
        this.addBooster(data, data.killer);
    }

    private void addBooster(OnLootGenerated data, Entity entity) {
        LootHelper.getLootTable((ResourceLocation)this.lootTable).m_287195_(LootHelper.toGiftParams((Entity)entity)).forEach(arg_0 -> ((ObjectArrayList)data.generatedLoot).add(arg_0));
    }
}

