/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.config;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import net.minecraft.util.Mth;

public class Config {
    static {
        Serializables.getStatic(Config.class).define("accessories", Accessories.class).define("boosters", Boosters.class).define("efficiency", Efficiency.class);
        Serializables.getStatic(Accessories.class);
        Serializables.getStatic(Boosters.class);
        Serializables.getStatic(Efficiency.class).define("range", Reader.range((IReader)Reader.number()), () -> Efficiency.RANGE, v -> {
            Efficiency.RANGE = Range.of((Number)Float.valueOf(-1.0f), (Number)Float.valueOf(10.0f)).clamp(v);
        }).define("average", Reader.number(), () -> Float.valueOf(Efficiency.AVG), v -> {
            Efficiency.AVG = ((Float)Range.of((Number)Float.valueOf(-1.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("standard_deviation", Reader.number(), () -> Float.valueOf(Efficiency.STD), v -> {
            Efficiency.STD = ((Float)Range.of((Number)Float.valueOf(-1.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    public static class Efficiency {
        public static Range<Float> RANGE = Range.of((Number)Float.valueOf(-0.6f), (Number)Float.valueOf(0.6f));
        public static float AVG = 0.0f;
        public static float STD = 0.2f;

        public static float getRandom() {
            if ((double)Math.abs(((Float)Efficiency.RANGE.to).floatValue() - ((Float)Efficiency.RANGE.from).floatValue()) < 1.0E-5) {
                return ((Float)Efficiency.RANGE.from).floatValue();
            }
            return RANGE.lerp(Efficiency.getGaussianRatio());
        }

        public static float getGaussianRatio() {
            return Mth.m_14036_((float)((float)((Random.nextGaussian() * (double)STD + (double)AVG - (double)((Float)Efficiency.RANGE.from).floatValue()) / (double)(((Float)Efficiency.RANGE.to).floatValue() - ((Float)Efficiency.RANGE.from).floatValue()))), (float)0.0f, (float)1.0f);
        }
    }

    public static class Accessories {
    }

    public static class Boosters {
    }
}

