/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.boosters.components;

import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.events.OnExpOrbPickedUp;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.world.entity.LivingEntity;

public class ExperienceBonus
extends BonusComponent<BoosterItem> {
    RangedFloat bonus = new RangedFloat().id("experience_bonus");

    public static BonusComponent.ISupplier<BoosterItem> create(float bonus) {
        return handler -> new ExperienceBonus(handler, bonus);
    }

    protected ExperienceBonus(BonusHandler<BoosterItem> handler, float bonus) {
        super(handler);
        this.bonus.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnExpOrbPickedUp.listen(this::increaseExperience);
        this.addTooltip("majruszsaccessories.boosters.experience_bonus", TooltipHelper.asBooster(() -> (BoosterItem)((Object)((Object)this.getItem()))), TooltipHelper.asFixedPercent(this.bonus));
        this.bonus.define((SerializableObject<?>)handler.getConfig());
    }

    private void increaseExperience(OnExpOrbPickedUp data) {
        data.experience += Random.round((double)((float)data.original * this.bonus.get() * (float)AccessoryHolders.get((LivingEntity)data.player).getBoostersCount(() -> (BoosterItem)((Object)((Object)this.getItem())))));
    }
}

