/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class MiningExtraItem
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);
    Map<String, ResourceLocation> lootIds = DefaultMap.of((DefaultMap.Entry[])new DefaultMap.Entry[]{DefaultMap.defaultEntry((Object)MajruszsAccessories.HELPER.getLocation("gameplay/lucky_rock_default")), DefaultMap.entry((String)"minecraft:the_nether", (Object)MajruszsAccessories.HELPER.getLocation("gameplay/lucky_rock_nether")), DefaultMap.entry((String)"minecraft:the_end", (Object)MajruszsAccessories.HELPER.getLocation("gameplay/lucky_rock_end"))});

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new MiningExtraItem(handler, chance);
    }

    protected MiningExtraItem(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnStoneMined.listen(this::addExtraLoot);
        this.addTooltip("majruszsaccessories.bonuses.extra_stone_loot", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("extra_mining_item", subconfig -> {
            this.chance.define((SerializableObject<?>)subconfig);
            subconfig.define("loot_ids", Reader.map((IReader)Reader.location()), s -> this.lootIds, (s, v) -> {
                this.lootIds = DefaultMap.of((Map)v);
            });
        });
    }

    private void addExtraLoot(OnLootGenerated data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.entity).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        LivingEntity entity = (LivingEntity)data.entity;
        ResourceLocation id = this.lootIds.get(entity.m_9236_().m_46472_().m_135782_().toString());
        data.generatedLoot.addAll((ObjectList)LootHelper.getLootTable((ResourceLocation)id).m_287195_(LootHelper.toGiftParams((Entity)entity)));
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnLootGenerated data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(3).offset(ParticleEmitter.offset((float)0.2f)).position(data.origin).emit((Level)data.getServerLevel());
    }

    public static class OnStoneMined {
        public static Event<OnLootGenerated> listen(Consumer<OnLootGenerated> consumer) {
            return OnLootGenerated.listen(consumer).addCondition(Condition.isLogicalServer()).addCondition(data -> data.blockState != null).addCondition(data -> data.blockState.m_204336_(BlockTags.f_13061_) || data.blockState.m_204336_(BlockTags.f_13062_) || data.blockState.m_60713_(Blocks.f_50259_)).addCondition(data -> data.entity instanceof LivingEntity).addCondition(data -> data.origin != null);
        }
    }
}

