/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnItemDamaged;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MiningDurabilityBonus
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new MiningDurabilityBonus(handler, bonus);
    }

    protected MiningDurabilityBonus(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.chance.set(bonus, (Range<Float>)Range.CHANCE);
        OnItemDamaged.listen(this::decreaseDurabilityCost).addCondition(data -> data.player != null);
        this.addTooltip("majruszsaccessories.bonuses.free_durability_cost", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("mining_free_durability_use", this.chance::define);
    }

    private void decreaseDurabilityCost(OnItemDamaged data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        data.damage = 0;
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnItemDamaged data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(3).sizeBased((Entity)data.player).emit((Level)data.getServerLevel());
    }
}

