/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.OnPlayerTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FishingLuckBonus
extends BonusComponent<AccessoryItem> {
    final AttributeHandler attribute;
    RangedFloat luck = new RangedFloat().id("bonus").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float luck) {
        return handler -> new FishingLuckBonus(handler, luck);
    }

    protected FishingLuckBonus(BonusHandler<AccessoryItem> handler, float luck) {
        super(handler);
        this.attribute = new AttributeHandler("%s_fishing_luck_bonus".formatted(handler.getId()), () -> Attributes.f_22286_, AttributeModifier.Operation.ADDITION);
        this.luck.set(luck, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));
        OnPlayerTicked.listen(this::updateLuck).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)4.0f));
        OnItemFished.listen(this::spawnEffects).addCondition(Condition.isLogicalServer());
        this.addTooltip("majruszsaccessories.bonuses.fishing_luck", TooltipHelper.asValue(this.luck));
        handler.getConfig().define("fishing_luck", this.luck::define);
    }

    private void updateLuck(OnPlayerTicked data) {
        this.attribute.setValue((double)this.getLuck(data.player)).apply((LivingEntity)data.player);
    }

    private float getLuck(Player player) {
        if (player.f_36083_ == null) {
            return 0.0f;
        }
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        return holder.isValid() && !holder.isBonusDisabled() ? holder.apply(this.luck) : 0.0f;
    }

    private void spawnEffects(OnItemFished data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        BlockPos position = LevelHelper.getPositionOverFluid((Level)data.getLevel(), (BlockPos)data.hook.m_20183_());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.m_20185_(), (Number)((double)position.m_123342_() + 0.25), (Number)data.hook.m_20189_()).vec3()).emit((Level)data.getServerLevel());
    }
}

