/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnFishingExtraItemsGet;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class FishingExtraTreasure
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new FishingExtraTreasure(handler, chance);
    }

    protected FishingExtraTreasure(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnFishingExtraItemsGet.listen(this::addExtraTreasure);
        this.addTooltip("majruszsaccessories.bonuses.extra_fishing_treasure", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("extra_fishing_treasure", this.chance::define);
    }

    private void addExtraTreasure(OnFishingExtraItemsGet data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        data.extraItems.addAll(LootHelper.getLootTable((ResourceLocation)BuiltInLootTables.f_78722_).m_287195_(LootHelper.toGiftParams((Entity)data.player)));
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnFishingExtraItemsGet data, AccessoryHolder holder) {
        BlockPos position = LevelHelper.getPositionOverFluid((Level)data.getLevel(), (BlockPos)data.hook.m_20183_());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.m_20185_(), (Number)((double)position.m_123342_() + 0.25), (Number)data.hook.m_20189_()).vec3()).emit((Level)data.getServerLevel());
    }
}

