/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnItemBrushed;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BrushingExtraItem
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new BrushingExtraItem(handler, chance);
    }

    protected BrushingExtraItem(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnItemBrushed.listen(this::addExtraLoot);
        this.addTooltip("majruszsaccessories.bonuses.extra_archaeology_item", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("extra_archaeology_item", this.chance::define);
    }

    private void addExtraLoot(OnItemBrushed data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        float width = EntityType.f_20461_.m_20678_();
        float height = EntityType.f_20461_.m_20679_();
        Vec3 itemOffset = AnyPos.from((Direction)data.direction).mul((Number)Float.valueOf(width), (Number)Float.valueOf(height), (Number)Float.valueOf(width)).mul((Number)Float.valueOf(0.5f)).vec3();
        Vec3 start = AnyPos.from((BlockPos)data.blockEntity.m_58899_()).center().add(data.direction).add(itemOffset).vec3();
        Vec3 end = AnyPos.from((BlockPos)data.blockEntity.m_58899_()).center().add(AnyPos.from((Direction)data.direction).mul((Number)1.5)).vec3();
        ObjectArrayList extraItems = LootHelper.getLootTable((ResourceLocation)data.location).m_287195_(LootHelper.toGiftParams((Entity)data.player));
        for (ItemStack itemStack : extraItems) {
            LevelHelper.spawnItemEntityFlyingTowardsDirection((ItemStack)itemStack, (Level)data.getLevel(), (Vec3)start, (Vec3)end);
        }
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnItemBrushed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(8).position(AnyPos.from((BlockPos)data.blockEntity.m_58899_()).center().add(data.direction).vec3()).emit((Level)data.getServerLevel());
    }
}

