/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.RegexString;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.BrushingExtraItem;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.base.CustomConditions;
import com.majruszsaccessories.items.AccessoryItem;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

@AutoInstance
public class AncientScarab
extends AccessoryHandler {
    public AncientScarab() {
        super(MajruszsAccessories.ANCIENT_SCARAB, AncientScarab.class);
        this.add(BrushingExtraItem.create(0.16f)).add(SuspiciousBlocksDropChance.create()).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.ADVENTURER_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    static class SuspiciousBlocksDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.125f;
        List<RegexString> locations = RegexString.toRegex(List.of(BuiltInLootTables.f_276662_.toString(), BuiltInLootTables.f_276661_.toString(), BuiltInLootTables.f_279573_.toString(), BuiltInLootTables.f_279604_.toString(), BuiltInLootTables.f_276611_.toString(), BuiltInLootTables.f_276614_.toString(), "{regex}.*archaeology.*"));

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return SuspiciousBlocksDropChance::new;
        }

        protected SuspiciousBlocksDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            OnLootGenerated.listen(x$0 -> this.replaceGeneratedLoot((OnLootGenerated)x$0)).addCondition(Condition.isLogicalServer()).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer)).addCondition(CustomConditions.dropChance(() -> Float.valueOf(this.chance), data -> data.entity)).addCondition(data -> this.locations.stream().anyMatch(id -> id.matches(data.lootId.toString()))).addCondition(data -> data.origin != null);
            handler.getConfig().define("suspicious_block_spawn_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            }).define("suspicious_block_ids", Reader.list((IReader)Reader.string()), s -> RegexString.toString(this.locations), (s, v) -> {
                this.locations = RegexString.toRegex((List)v);
            });
        }
    }
}

