/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AbstractFlyingProjectile;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BigShulkerBulletEntity
extends AbstractFlyingProjectile {
    private static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(BigShulkerBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(BigShulkerBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private double spiralAngle = 0.0;
    private final double spiralSpeed = 0.05;
    private final double spiralRadius = 0.05;
    private double baseSpeed = 0.5;

    public BigShulkerBulletEntity(EntityType<? extends BigShulkerBulletEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BigShulkerBulletEntity(Level pLevel, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, float size) {
        super((EntityType<? extends AbstractFlyingProjectile>)((EntityType)ModEntities.BIG_SHULKER_BULLET.get()), pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.setSize(size);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(1.0f * (this.getSize() * 1.25f)), (float)(1.0f * (this.getSize() * 1.25f)));
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (SIZE.equals(p_21104_)) {
            this.m_6210_();
        }
        super.m_7350_(p_21104_);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    public void m_8119_() {
        Vec3 up;
        super.m_8119_();
        this.spiralAngle += 0.05;
        Vec3 motion = this.m_20184_();
        if (motion.m_82556_() < 1.0E-6) {
            return;
        }
        Vec3 forward = motion.m_82541_();
        Vec3 right = forward.m_82537_(up = new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (right.m_82556_() < 1.0E-6) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 up2 = right.m_82537_(forward).m_82541_();
        double cos = Math.cos(this.spiralAngle) * 0.05;
        double sin = Math.sin(this.spiralAngle) * 0.05;
        Vec3 offset = right.m_82490_(cos).m_82549_(up2.m_82490_(sin));
        Vec3 newMotion = forward.m_82549_(offset).m_82541_().m_82490_(this.baseSpeed);
    }

    public float m_7077_(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, float pExplosionPower) {
        return this.isDangerous() && pBlockState.canEntityDestroy(pLevel, pPos, (Entity)this) ? Math.min(0.8f, pExplosionPower) : pExplosionPower;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123810_;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (pResult.m_82443_() == this.m_19749_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            boolean flag;
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 5.0f + this.getSize() * 3.0f);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 5.0f + this.getSize() * 3.0f);
            }
            if (flag && entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                livingentity1.m_147207_(new MobEffectInstance(MobEffects.f_19620_, 40, 1), this.m_150173_());
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)false);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pInvulnerable) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pInvulnerable);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

