/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.capabilities;

import io.github.apace100.origins.component.OriginComponent;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeOrigin;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public interface IOriginContainer
extends INBTSerializable<Tag> {
    public static LazyOptional<IOriginContainer> get(@Nullable Entity entity) {
        return entity != null ? entity.getCapability(OriginsAPI.ORIGIN_CONTAINER) : LazyOptional.empty();
    }

    public void setOrigin(ResourceKey<OriginLayer> var1, ResourceKey<Origin> var2);

    default public void setOrigin(Holder<OriginLayer> layer, Holder<Origin> origin) {
        ResourceKey layerKey = (ResourceKey)layer.m_203439_().map(Function.identity(), originLayer -> (ResourceKey)OriginsAPI.getLayersRegistry().m_7854_(originLayer).orElseThrow(() -> new IllegalArgumentException("Tried to assign an unregistered layer to player " + this.getOwner().m_6302_() + ": " + layer)));
        ResourceKey originKey = (ResourceKey)origin.m_203439_().map(Function.identity(), originLayer -> (ResourceKey)OriginsAPI.getOriginsRegistry().m_7854_(originLayer).orElseThrow(() -> new IllegalArgumentException("Tried to assign an unregistered origin to player " + this.getOwner().m_6302_() + ": " + layer)));
        this.setOrigin((ResourceKey<OriginLayer>)layerKey, (ResourceKey<Origin>)originKey);
    }

    default public void setOrigin(OriginLayer layer, Origin origin) {
        Optional layerKey = OriginsAPI.getLayersRegistry().m_7854_((Object)layer);
        Optional originKey = OriginsAPI.getOriginsRegistry().m_7854_((Object)origin);
        if (layerKey.isEmpty()) {
            throw new IllegalArgumentException("Tried to assign an unregistered layer to player " + this.getOwner().m_6302_() + ": " + layer);
        }
        if (originKey.isEmpty()) {
            throw new IllegalArgumentException("Tried to assign an unregistered origin to player " + this.getOwner().m_6302_() + ": " + origin);
        }
        this.setOrigin((ResourceKey<OriginLayer>)((ResourceKey)layerKey.get()), (ResourceKey<Origin>)((ResourceKey)originKey.get()));
    }

    public ResourceKey<Origin> getOrigin(ResourceKey<OriginLayer> var1);

    default public ResourceKey<Origin> getOrigin(Holder<OriginLayer> layer) {
        ResourceKey key = ((Optional)layer.m_203439_().map(Optional::of, arg_0 -> OriginsAPI.getLayersRegistry().m_7854_(arg_0))).orElse(null);
        Validate.notNull((Object)key, (String)"Cannot get status for unregistered layer.", (Object[])new Object[0]);
        return this.getOrigin((ResourceKey<OriginLayer>)key);
    }

    @Deprecated
    default public ResourceKey<Origin> getOrigin(OriginLayer layer) {
        ResourceKey key = OriginsAPI.getLayersRegistry().m_7854_((Object)layer).orElse(null);
        Validate.notNull((Object)key, (String)"Cannot get status for unregistered layer.", (Object[])new Object[0]);
        return this.getOrigin((ResourceKey<OriginLayer>)key);
    }

    public boolean hasOrigin(ResourceKey<OriginLayer> var1);

    default public boolean hasOrigin(Holder<OriginLayer> layer) {
        ResourceKey key = ((Optional)layer.m_203439_().map(Optional::of, arg_0 -> OriginsAPI.getLayersRegistry().m_7854_(arg_0))).orElse(null);
        Validate.notNull((Object)key, (String)"Cannot get status for unregistered layer.", (Object[])new Object[0]);
        return this.hasOrigin((ResourceKey<OriginLayer>)key);
    }

    @Deprecated
    default public boolean hasOrigin(OriginLayer layer) {
        ResourceKey key = OriginsAPI.getLayersRegistry().m_7854_((Object)layer).orElse(null);
        Validate.notNull((Object)key, (String)"Cannot get status for unregistered layer.", (Object[])new Object[0]);
        return this.hasOrigin((ResourceKey<OriginLayer>)key);
    }

    default public boolean hasAllOrigins() {
        return OriginsAPI.getActiveLayers().stream().filter(x -> !((OriginLayer)x.m_203334_()).empty(this.getOwner())).allMatch(this::hasOrigin);
    }

    public boolean hadAllOrigins();

    public Map<ResourceKey<OriginLayer>, ResourceKey<Origin>> getOrigins();

    public void synchronize();

    public boolean shouldSync();

    public void tick();

    public void validateSynchronization();

    public S2CSynchronizeOrigin getSynchronizationPacket();

    public boolean checkAutoChoosingLayers(boolean var1);

    public void onChosen(ResourceKey<Origin> var1, boolean var2);

    public void onChosen(boolean var1);

    public void onReload(ICalioDynamicRegistryManager var1);

    public OriginComponent asLegacyComponent();

    public Player getOwner();
}

