/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import com.mojang.serialization.Codec;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.origins.badge.Badge;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class BadgeFactory
implements DataObjectFactory<Badge> {
    private final ResourceLocation id;
    private final SerializableData data;
    private final Function<SerializableData.Instance, Badge> factory;
    private final Codec<Badge> codec;

    public BadgeFactory(ResourceLocation id, SerializableData data, Function<SerializableData.Instance, Badge> factory) {
        this.id = id;
        this.data = data;
        this.factory = factory;
        this.codec = data.xmap(factory, x -> x.toData(new SerializableData.Instance(this.data()))).codec();
    }

    public Codec<Badge> getCodec() {
        return this.codec;
    }

    public SerializableData getData() {
        return this.data;
    }

    public Badge fromData(SerializableData.Instance instance) {
        return this.factory().apply(instance);
    }

    public SerializableData.Instance toData(Badge badge) {
        return badge.toData(new SerializableData.Instance(this.data));
    }

    public ResourceLocation id() {
        return this.id;
    }

    public SerializableData data() {
        return this.data;
    }

    public Function<SerializableData.Instance, Badge> factory() {
        return this.factory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BadgeFactory that = (BadgeFactory)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.data, that.data) && Objects.equals(this.factory, that.factory);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data, this.factory);
    }

    public String toString() {
        return "BadgeFactory[id=" + this.id + ", data=" + this.data + ", factory=" + this.factory + "]";
    }
}

