/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.bom.ChanceMaterialCost;
import dev.emi.emi.bom.FlatMaterialCost;
import dev.emi.emi.bom.MaterialNode;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiPersistentData;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class EmiFavorites {
    public static List<EmiFavorite> favorites = Lists.newArrayList();
    public static List<EmiFavorite.Synthetic> syntheticFavorites = Lists.newArrayList();
    public static List<EmiFavorite> favoriteSidebar = new CompoundList<EmiFavorite.Synthetic>(favorites, syntheticFavorites);

    public static JsonArray save() {
        JsonArray arr = new JsonArray();
        for (EmiFavorite fav : favorites) {
            JsonElement stack = EmiIngredientSerializer.getSerialized(fav.getStack());
            if (stack == null) continue;
            JsonObject obj = new JsonObject();
            obj.add("stack", stack);
            if (fav.getRecipe() != null && fav.getRecipe().getId() != null) {
                obj.addProperty("recipe", fav.getRecipe().getId().toString());
            }
            arr.add((JsonElement)obj);
        }
        return arr;
    }

    public static void load(JsonArray arr) {
        favorites.clear();
        for (JsonElement el : arr) {
            EmiIngredient ingredient;
            if (!el.isJsonObject()) continue;
            JsonObject json = el.getAsJsonObject();
            EmiRecipe recipe = null;
            if (GsonHelper.m_13813_((JsonObject)json, (String)"recipe")) {
                recipe = EmiApi.getRecipeManager().getRecipe(EmiPort.id(GsonHelper.m_13906_((JsonObject)json, (String)"recipe")));
            }
            if (!GsonHelper.m_13900_((JsonObject)json, (String)"stack") || (ingredient = EmiIngredientSerializer.getDeserialized(json.get("stack"))).isEmpty()) continue;
            if (ingredient instanceof EmiStack) {
                EmiStack es = (EmiStack)ingredient;
                ingredient = es.copy();
            }
            favorites.add(new EmiFavorite(ingredient, recipe));
        }
    }

    public static boolean canFavorite(EmiIngredient stack, EmiRecipe recipe) {
        if ((stack = EmiIngredientSerializer.getDeserialized(EmiIngredientSerializer.getSerialized(stack))).isEmpty()) {
            return false;
        }
        if (recipe != null) {
            return recipe.getId() != null;
        }
        return true;
    }

    private static int indexOf(EmiIngredient stack) {
        for (int i = 0; i < favorites.size(); ++i) {
            if (!favorites.get(i).strictEquals(stack) || favorites.get(i).getRecipe() != EmiApi.getRecipeContext(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean removeFavorite(EmiIngredient stack) {
        int index = EmiFavorites.indexOf(stack);
        if (index != -1) {
            favorites.remove(index);
            return true;
        }
        return false;
    }

    public static void addFavorite(EmiIngredient stack) {
        EmiFavorites.addFavorite(stack, null);
    }

    public static void addFavoriteAt(EmiIngredient stack, int offset) {
        EmiFavorite favorite;
        if (stack instanceof EmiFavorite.Synthetic) {
            return;
        }
        if (stack instanceof EmiFavorite.Craftable) {
            EmiFavorite.Craftable craftable = (EmiFavorite.Craftable)stack;
            stack = craftable.stack;
        }
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            int original = EmiFavorites.indexOf(stack);
            if (original != -1) {
                if (original < offset) {
                    --offset;
                }
                favorites.remove(original);
            }
            favorite = fav;
        } else {
            if ((stack = EmiIngredientSerializer.getDeserialized(EmiIngredientSerializer.getSerialized(stack))).isEmpty()) {
                return;
            }
            for (int i = 0; i < favorites.size(); ++i) {
                EmiFavorite fav = favorites.get(i);
                if (fav.getRecipe() != null || !fav.strictEquals(stack)) continue;
                favorites.remove(i--);
            }
            favorite = new EmiFavorite(stack, null);
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= favorites.size()) {
            favorites.add(favorite);
        } else {
            favorites.add(offset, favorite);
        }
        EmiPersistentData.save();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void addFavorite(EmiIngredient stack, EmiRecipe context) {
        block8: {
            block11: {
                EmiStack es;
                block10: {
                    block9: {
                        block7: {
                            if (stack instanceof EmiFavorite.Synthetic) {
                                return;
                            }
                            if (stack instanceof EmiFavorite.Craftable) {
                                EmiFavorite.Craftable craftable = (EmiFavorite.Craftable)stack;
                                stack = craftable.stack;
                            }
                            if (!(stack instanceof EmiFavorite)) break block7;
                            EmiFavorite f = (EmiFavorite)stack;
                            if (!EmiFavorites.removeFavorite(f)) {
                                favorites.add(f);
                            }
                            break block8;
                        }
                        if (!((stack = EmiIngredientSerializer.getDeserialized(EmiIngredientSerializer.getSerialized(stack))) instanceof EmiStack)) break block9;
                        es = (EmiStack)stack;
                        if (context == null || context.getId() == null) break block9;
                        if ((es = es.copy()) instanceof ItemEmiStack) {
                            ItemEmiStack ies = (ItemEmiStack)es;
                            ies.getItemStack().m_41764_(1);
                        }
                        if (es.isEmpty()) break block8;
                        break block10;
                    }
                    if (stack.isEmpty()) {
                        return;
                    }
                    break block11;
                }
                for (int i = 0; i < favorites.size(); ++i) {
                    EmiFavorite fav = favorites.get(i);
                    if (fav.getRecipe() != context || !fav.strictEquals(es)) continue;
                    return;
                }
                favorites.add(new EmiFavorite(es, context));
                break block8;
            }
            for (int i = 0; i < favorites.size(); ++i) {
                EmiFavorite fav = favorites.get(i);
                if (fav.getRecipe() != null || !fav.strictEquals(stack)) continue;
                return;
            }
            favorites.add(new EmiFavorite(stack, null));
        }
        EmiPersistentData.save();
    }

    public static void updateSynthetic(EmiPlayerInventory inv) {
        syntheticFavorites.clear();
        if (BoM.tree != null && BoM.craftingMode) {
            BoM.tree.calculateCost();
            HashMap originalCosts = Maps.newHashMap(BoM.tree.cost.costs);
            HashMap chancedCosts = Maps.newHashMap(BoM.tree.cost.chanceCosts);
            Object2LongLinkedOpenHashMap originalBatches = new Object2LongLinkedOpenHashMap();
            Object2LongLinkedOpenHashMap originalAmounts = new Object2LongLinkedOpenHashMap();
            EmiPlayerInventory emptyInventory = new EmiPlayerInventory(List.of());
            emptyInventory.inventory.clear();
            BoM.tree.calculateProgress(emptyInventory);
            EmiFavorites.countRecipes((Object2LongMap<EmiRecipe>)originalBatches, (Object2LongMap<EmiRecipe>)originalAmounts, BoM.tree.goal);
            BoM.tree.calculateProgress(inv);
            Object2LongLinkedOpenHashMap batches = new Object2LongLinkedOpenHashMap();
            Object2LongLinkedOpenHashMap amounts = new Object2LongLinkedOpenHashMap();
            EmiFavorites.countRecipes((Object2LongMap<EmiRecipe>)batches, (Object2LongMap<EmiRecipe>)amounts, BoM.tree.goal);
            boolean hasSomething = false;
            for (Object2LongMap.Entry entry : batches.object2LongEntrySet()) {
                EmiRecipe recipe = (EmiRecipe)entry.getKey();
                long amount = amounts.getOrDefault((Object)recipe, 0L);
                long batch = entry.getLongValue();
                if (amount == 0L) continue;
                hasSomething = true;
                int state = 0;
                if (inv.canCraft(recipe, batch)) {
                    state = 2;
                } else if (inv.canCraft(recipe)) {
                    state = 1;
                }
                syntheticFavorites.add(new EmiFavorite.Synthetic(recipe, batch, amount, originalAmounts.getOrDefault((Object)recipe, amount), state));
            }
            if (!hasSomething) {
                BoM.craftingMode = false;
            } else {
                for (FlatMaterialCost flatMaterialCost : BoM.tree.cost.costs.values()) {
                    if (flatMaterialCost.amount <= 0L) continue;
                    syntheticFavorites.add(new EmiFavorite.Synthetic(flatMaterialCost.ingredient, flatMaterialCost.amount, originalCosts.getOrDefault((Object)flatMaterialCost.ingredient, flatMaterialCost).amount));
                }
                for (ChanceMaterialCost chanceMaterialCost : BoM.tree.cost.chanceCosts.values()) {
                    if (chanceMaterialCost.getEffectiveAmount() <= 0L) continue;
                    long needed = chanceMaterialCost.getEffectiveAmount();
                    if (chancedCosts.containsKey(chanceMaterialCost.ingredient)) {
                        ChanceMaterialCost original = (ChanceMaterialCost)chancedCosts.get(chanceMaterialCost.ingredient);
                        long done = (long)Math.ceil((float)original.amount * original.chance - (float)chanceMaterialCost.amount * chanceMaterialCost.chance);
                        needed = original.getEffectiveAmount() - done;
                    }
                    if (needed <= 0L) continue;
                    syntheticFavorites.add(new EmiFavorite.Synthetic(chanceMaterialCost.ingredient, needed, needed));
                }
            }
        }
    }

    public static void countRecipes(Object2LongMap<EmiRecipe> batches, Object2LongMap<EmiRecipe> amounts, MaterialNode node) {
        EmiRecipe emiRecipe = node.recipe;
        if (emiRecipe instanceof EmiResolutionRecipe) {
            EmiResolutionRecipe recipe = (EmiResolutionRecipe)emiRecipe;
            EmiFavorites.countRecipes(batches, amounts, node.children.get(0));
            return;
        }
        if (node.recipe != null) {
            long amount = node.neededBatches;
            if (batches.containsKey((Object)node.recipe)) {
                amount += batches.getLong((Object)node.recipe);
                batches.removeLong((Object)node.recipe);
            }
            batches.put((Object)node.recipe, amount);
            amount = node.totalNeeded;
            if (amounts.containsKey((Object)node.recipe)) {
                amount += amounts.getLong((Object)node.recipe);
                amounts.removeLong((Object)node.recipe);
            }
            amounts.put((Object)node.recipe, amount);
            for (MaterialNode child : node.children) {
                EmiFavorites.countRecipes(batches, amounts, child);
            }
        }
    }

    private static class CompoundList<T>
    extends AbstractList<T> {
        private List<? extends T> a;
        private List<? extends T> b;

        public CompoundList(List<? extends T> a, List<? extends T> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public T get(int index) {
            if (index >= this.a.size()) {
                return this.b.get(index - this.a.size());
            }
            return this.a.get(index);
        }

        @Override
        public int size() {
            return this.a.size() + this.b.size();
        }
    }
}

