/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean addRope(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, int maxDist) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.m_121945_(moveDir), level, player, hand, ropeBlock, moveDir, maxDist);
        }
        if (state.m_60734_() instanceof PulleyBlock && (blockEntity = level.m_7702_(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)blockEntity;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.placeAndMove(player, hand, level, pos, moveDir, ropeBlock);
    }

    public static boolean isCorrectRope(Block ropeBlock, BlockState state, Direction direction) {
        if (state.m_60734_() instanceof ChainBlock && state.m_61143_((Property)ChainBlock.f_55923_) != direction.m_122434_()) {
            return false;
        }
        return ropeBlock == state.m_60734_();
    }

    public static boolean placeAndMove(@Nullable Player player, InteractionHand hand, Level level, BlockPos originPos, Direction moveDir, @Nullable Block placeWhereItWas) {
        BlockEntity te;
        boolean needsToPush;
        BlockState originalState = level.m_8055_(originPos);
        BlockPos targetPos = originPos.m_121945_(moveDir);
        BlockState targetState = level.m_8055_(targetPos);
        CompoundTag tileTag = null;
        boolean bl = needsToPush = !originalState.m_247087_();
        if (needsToPush) {
            if (!targetState.m_247087_() && placeWhereItWas != null) {
                return false;
            }
            if (!RopeHelper.isPushableByRopes(originalState, level, originPos, moveDir)) {
                return false;
            }
            BlockEntity tile = level.m_7702_(originPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(originalState)) {
                    return false;
                }
                tile.m_7651_();
                tileTag = tile.m_187482_();
            }
        }
        FluidState originalFluid = level.m_6425_(originPos);
        if (placeWhereItWas != null) {
            level.m_7731_(originPos, originalFluid.m_76188_(), 18);
            ItemStack stack = new ItemStack((ItemLike)placeWhereItWas);
            BlockPlaceContext context = new BlockPlaceContext(level, player, hand, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)originPos), moveDir.m_122424_(), originPos, false));
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                InteractionResult placeResult = bi.m_40576_(context);
                if (placeResult == InteractionResult.PASS || placeResult == InteractionResult.FAIL) {
                    level.m_7731_(originPos, originalState, 4);
                    return false;
                }
                if (!needsToPush) {
                    return true;
                }
            }
        } else {
            level.m_46597_(originPos, originalFluid.m_76188_());
        }
        FluidState targetFluid = level.m_6425_(targetPos);
        boolean waterFluid = targetFluid.m_192917_((Fluid)Fluids.f_76193_);
        if (originalState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            boolean canHoldWater = originalState.m_204336_(ModTags.WATER_HOLDER);
            if (!canHoldWater) {
                originalState = (BlockState)originalState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterFluid));
            }
        } else if (originalState.m_60734_() instanceof AbstractCauldronBlock) {
            if (waterFluid && originalState.m_60713_(Blocks.f_50256_) || originalState.m_60713_(Blocks.f_152476_)) {
                originalState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
            } else if (targetFluid.m_192917_((Fluid)Fluids.f_76195_) && originalState.m_60713_(Blocks.f_50256_) || originalState.m_60713_(Blocks.f_152477_)) {
                originalState = Blocks.f_152477_.m_49966_();
            } else if (CompatHandler.AMENDMENTS) {
                originalState = AmendmentsCompat.fillCauldronWithFluid(level, targetPos, originalState, targetFluid);
            }
        }
        originalState = Block.m_49931_((BlockState)originalState, (LevelAccessor)level, (BlockPos)targetPos);
        level.m_46597_(targetPos, originalState);
        if (tileTag != null && (te = level.m_7702_(targetPos)) != null) {
            te.m_142466_(tileTag);
        }
        return true;
    }

    public static boolean removeRopeDown(BlockPos pos, Level level, Block ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean removeRope(BlockPos pos, Level level, Block ropeBlock, Direction moveUpDir, int maxDist) {
        PulleyBlockTile te;
        BlockEntity blockEntity;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        BlockState state = level.m_8055_(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.m_121945_(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.m_60734_() instanceof PulleyBlock && (blockEntity = level.m_7702_(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)blockEntity).m_7983_()) {
            return te.rotateIndirect(null, InteractionHand.MAIN_HAND, ropeBlock, moveUpDir, true);
        }
        BlockPos up = pos.m_121945_(moveUpDir.m_122424_());
        if (level.m_8055_(up).m_60734_() != ropeBlock) {
            return false;
        }
        if (!RopeHelper.placeAndMove(null, InteractionHand.MAIN_HAND, level, pos, moveUpDir.m_122424_(), null)) {
            level.m_46597_(up, level.m_6425_(up).m_76188_());
        }
        return true;
    }

    public static boolean isPushableByRopes(BlockState state, Level level, BlockPos pos, Direction moveDir) {
        if (state.m_60734_() instanceof PulleyBlock) {
            return false;
        }
        if (state.m_204336_(ModTags.ROPE_PUSH_BLACKLIST)) {
            return false;
        }
        if (!state.m_280296_()) {
            return false;
        }
        if (moveDir.m_122434_().m_122478_() && state.m_204336_(ModTags.ROPE_HANG_TAG)) {
            return true;
        }
        boolean couldBreak = !state.m_280296_();
        return RopeHelper.isPushable(state, level, pos, moveDir, couldBreak, moveDir);
    }

    private static boolean isPushable(BlockState state, Level level, BlockPos pos, Direction movementDirection, boolean allowDestroy, Direction pistonFacing) {
        if (pos.m_123342_() >= level.m_141937_() && pos.m_123342_() <= level.m_151558_() - 1 && level.m_6857_().m_61937_(pos)) {
            if (state.m_60795_()) {
                return true;
            }
            if (!(state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_) || state.m_60713_(Blocks.f_50724_) || state.m_60713_(Blocks.f_220863_))) {
                if (movementDirection == Direction.DOWN && pos.m_123342_() == level.m_141937_()) {
                    return false;
                }
                if (movementDirection == Direction.UP && pos.m_123342_() == level.m_151558_() - 1) {
                    return false;
                }
                if (!state.m_60713_(Blocks.f_50039_) && !state.m_60713_(Blocks.f_50032_)) {
                    if (state.m_60800_((BlockGetter)level, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.m_60811_()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return allowDestroy;
                        }
                        case PUSH_ONLY: {
                            return movementDirection == pistonFacing;
                        }
                    }
                } else if (((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

