/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.enlightened_end.network;

import java.util.function.Supplier;
import net.mcreator.enlightened_end.EnlightenedEndMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnlightenedEndModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        EnlightenedEndMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        EnlightenedEndMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.radiated = message.data.radiated;
                    variables.radiation = message.data.radiation;
                    variables.flypacktime = message.data.flypacktime;
                    variables.dashing_cooldown = message.data.dashing_cooldown;
                    variables.raintimer = message.data.raintimer;
                    variables.oozeraindistant = message.data.oozeraindistant;
                    variables.barrenambiencetimer = message.data.barrenambiencetimer;
                    variables.endbarrenswind = message.data.endbarrenswind;
                    variables.oozerainhigh = message.data.oozerainhigh;
                    variables.music_time = message.data.music_time;
                    variables.end_playing = message.data.end_playing;
                    variables.enteredEnd = message.data.enteredEnd;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double radiated = 0.0;
        public double radiation = 0.0;
        public double flypacktime = 0.0;
        public double dashing_cooldown = 0.0;
        public double raintimer = 0.0;
        public double oozeraindistant = 0.0;
        public double barrenambiencetimer = 0.0;
        public double endbarrenswind = 0.0;
        public double oozerainhigh = 0.0;
        public double music_time = 0.0;
        public boolean end_playing = false;
        public boolean enteredEnd = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("radiated", this.radiated);
            nbt.m_128347_("radiation", this.radiation);
            nbt.m_128347_("flypacktime", this.flypacktime);
            nbt.m_128347_("dashing_cooldown", this.dashing_cooldown);
            nbt.m_128347_("raintimer", this.raintimer);
            nbt.m_128347_("oozeraindistant", this.oozeraindistant);
            nbt.m_128347_("barrenambiencetimer", this.barrenambiencetimer);
            nbt.m_128347_("endbarrenswind", this.endbarrenswind);
            nbt.m_128347_("oozerainhigh", this.oozerainhigh);
            nbt.m_128347_("music_time", this.music_time);
            nbt.m_128379_("end_playing", this.end_playing);
            nbt.m_128379_("enteredEnd", this.enteredEnd);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.radiated = nbt.m_128459_("radiated");
            this.radiation = nbt.m_128459_("radiation");
            this.flypacktime = nbt.m_128459_("flypacktime");
            this.dashing_cooldown = nbt.m_128459_("dashing_cooldown");
            this.raintimer = nbt.m_128459_("raintimer");
            this.oozeraindistant = nbt.m_128459_("oozeraindistant");
            this.barrenambiencetimer = nbt.m_128459_("barrenambiencetimer");
            this.endbarrenswind = nbt.m_128459_("endbarrenswind");
            this.oozerainhigh = nbt.m_128459_("oozerainhigh");
            this.music_time = nbt.m_128459_("music_time");
            this.end_playing = nbt.m_128471_("end_playing");
            this.enteredEnd = nbt.m_128471_("enteredEnd");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("enlightened_end", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "enlightened_end_mapvars";
        public double enlightendbiomeseed = 0.0;
        public double dsad = 0.0;
        public boolean dragon_slain = false;
        public boolean oozerain = false;
        public double endraintimetillend = 0.0;
        public double endraindelay = 0.0;
        public double endrainlast = 0.0;
        public double endraindo = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.enlightendbiomeseed = nbt.m_128459_("enlightendbiomeseed");
            this.dsad = nbt.m_128459_("dsad");
            this.dragon_slain = nbt.m_128471_("dragon_slain");
            this.oozerain = nbt.m_128471_("oozerain");
            this.endraintimetillend = nbt.m_128459_("endraintimetillend");
            this.endraindelay = nbt.m_128459_("endraindelay");
            this.endrainlast = nbt.m_128459_("endrainlast");
            this.endraindo = nbt.m_128459_("endraindo");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("enlightendbiomeseed", this.enlightendbiomeseed);
            nbt.m_128347_("dsad", this.dsad);
            nbt.m_128379_("dragon_slain", this.dragon_slain);
            nbt.m_128379_("oozerain", this.oozerain);
            nbt.m_128347_("endraintimetillend", this.endraintimetillend);
            nbt.m_128347_("endraindelay", this.endraindelay);
            nbt.m_128347_("endrainlast", this.endrainlast);
            nbt.m_128347_("endraindo", this.endraindo);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "enlightened_end_worldvars";
        public double endrainchance = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.endrainchance = nbt.m_128459_("endrainchance");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("endrainchance", this.endrainchance);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.barrenambiencetimer = original.barrenambiencetimer;
            clone.endbarrenswind = original.endbarrenswind;
            clone.music_time = original.music_time;
            clone.end_playing = original.end_playing;
            clone.enteredEnd = original.enteredEnd;
            if (!event.isWasDeath()) {
                clone.radiated = original.radiated;
                clone.radiation = original.radiation;
                clone.flypacktime = original.flypacktime;
                clone.dashing_cooldown = original.dashing_cooldown;
                clone.raintimer = original.raintimer;
                clone.oozeraindistant = original.oozeraindistant;
                clone.oozerainhigh = original.oozerainhigh;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                EnlightenedEndMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

