/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.xkmc.l2complements.content.enchantment.special.LifeSyncEnchantment;
import dev.xkmc.l2complements.events.EnchUtils;
import dev.xkmc.l2complements.events.SpecialEquipmentEvents;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import dev.xkmc.l2library.util.Proxy;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements IForgeItemStack {
    @Shadow
    public abstract boolean m_41793_();

    @ModifyVariable(at=@At(value="LOAD"), method={"hurtAndBreak"}, argsOnly=true)
    public int l2complements_hurtAndBreak_hardened(int pAmount) {
        ItemStack self = (ItemStack)this;
        if (pAmount > 1 && self.getEnchantmentLevel((Enchantment)LCEnchantments.HARDENED.get()) > 0) {
            return 1;
        }
        return pAmount;
    }

    @Inject(at={@At(value="HEAD")}, method={"hurtAndBreak"}, cancellable=true)
    public <T extends LivingEntity> void l2complements_hurtAndBreak_lifeSync(int pAmount, T pEntity, Consumer<T> pOnBroken, CallbackInfo ci) {
        ItemStack self = (ItemStack)this;
        if (pEntity.m_9236_().m_5776_()) {
            return;
        }
        if (self.getEnchantmentLevel((Enchantment)LCEnchantments.ETERNAL.get()) > 0) {
            ci.cancel();
        }
        if (self.getEnchantmentLevel((Enchantment)LCEnchantments.LIFE_SYNC.get()) > 0) {
            GeneralEventHandler.schedule(() -> pEntity.m_6469_(LifeSyncEnchantment.getSource(pEntity.m_9236_()), (float)((double)pAmount * (Double)LCConfig.COMMON.lifeSyncFactor.get())));
            ci.cancel();
        }
        if (!SpecialEquipmentEvents.PLAYER.get().isEmpty()) {
            BlockState state = (BlockState)SpecialEquipmentEvents.PLAYER.get().peek().getSecond();
            if (self.getEnchantmentLevel((Enchantment)LCEnchantments.TREE.get()) >= 2 && state.m_204336_(TagGen.AS_LEAF)) {
                ci.cancel();
            }
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setDamageValue(I)V")}, method={"hurt"})
    public void l2complements_hurt_safeguard_setDamage(ItemStack self, int val, Operation<Void> op) {
        Optional opt;
        int max = self.m_41776_();
        if (max <= val + 1 && self.getEnchantmentLevel((Enchantment)LCEnchantments.SAFEGUARD.get()) > 0 && (opt = Proxy.getServer()).isPresent()) {
            int old = self.m_41773_();
            String key = LCEnchantments.SAFEGUARD.getId().toString();
            long time = self.m_41784_().m_128454_(key);
            long current = ((MinecraftServer)opt.get()).m_129783_().m_46467_();
            if (max <= val) {
                if (current == time) {
                    val = old;
                } else if (max > old + 1) {
                    val = max - 1;
                    self.m_41784_().m_128356_(key, current);
                }
            } else if (max == val + 1) {
                self.m_41784_().m_128356_(key, current);
            }
        }
        op.call(new Object[]{self, val});
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"hurt"})
    public boolean l2complements_hurt_safeguard_preventBreaking(boolean broken) {
        ItemStack self = (ItemStack)this;
        return broken && self.m_41773_() >= self.m_41776_();
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getMaxDamage"})
    public int l2complements_getMaxDamage_durabilityEnchantment(int max) {
        ItemStack self = (ItemStack)this;
        if (!this.m_41793_()) {
            return max;
        }
        int lv = EnchUtils.getTagEnchantmentLevel((Enchantment)LCEnchantments.DURABLE_ARMOR.get(), self);
        return max * (1 + lv);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull Player player, @NotNull Entity target) {
        ItemStack self = (ItemStack)this;
        return self.m_41720_().getSweepHitBox(self, player, target);
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getSweepHitBox"}, remap=false)
    public AABB l2complements_getSweepHitBox_enchantOverride(AABB box) {
        int lv = this.getEnchantmentLevel((Enchantment)LCEnchantments.WIND_SWEEP.get());
        if (lv > 0) {
            double amount = (Double)LCConfig.COMMON.windSweepIncrement.get();
            box = box.m_82377_(amount * (double)lv, amount * (double)lv, amount * (double)lv);
        }
        return box;
    }

    public boolean makesPiglinsNeutral(LivingEntity wearer) {
        ItemStack self = (ItemStack)this;
        return self.m_41720_().makesPiglinsNeutral(self, wearer);
    }

    @Inject(at={@At(value="HEAD")}, method={"makesPiglinsNeutral"}, cancellable=true, remap=false)
    public void l2complements_makesPiglinsNeutral_enchantOverride(LivingEntity wearer, CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Enchantment)LCEnchantments.SHINNY.get()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean isPiglinCurrency() {
        ItemStack self = (ItemStack)this;
        return self.m_41720_().isPiglinCurrency(self);
    }

    @Inject(at={@At(value="HEAD")}, method={"isPiglinCurrency"}, cancellable=true, remap=false)
    public void l2complements_isPiglinCurrency_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Enchantment)LCEnchantments.SHINNY.get()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean isEnderMask(Player player, EnderMan endermanEntity) {
        ItemStack self = (ItemStack)this;
        return self.m_41720_().isEnderMask(self, player, endermanEntity);
    }

    @Inject(at={@At(value="HEAD")}, method={"isEnderMask"}, cancellable=true, remap=false)
    public void l2complements_isEnderMask_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Enchantment)LCEnchantments.ENDER_MASK.get()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        ItemStack self = (ItemStack)this;
        return self.m_41720_().canWalkOnPowderedSnow(self, wearer);
    }

    @Inject(at={@At(value="HEAD")}, method={"canWalkOnPowderedSnow"}, cancellable=true, remap=false)
    public void l2complements_canWalkOnPowderedSnow_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Enchantment)LCEnchantments.SNOW_WALKER.get()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }
}

