/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init.registrate;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.content.effect.force.ArmorReduceEffect;
import dev.xkmc.l2complements.content.effect.force.CurseEffect;
import dev.xkmc.l2complements.content.effect.force.FlameEffect;
import dev.xkmc.l2complements.content.effect.force.IceEffect;
import dev.xkmc.l2complements.content.effect.force.StoneCageEffect;
import dev.xkmc.l2complements.content.effect.skill.BleedEffect;
import dev.xkmc.l2complements.content.effect.skill.CleanseEffect;
import dev.xkmc.l2complements.content.effect.skill.EmeraldPopeEffect;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.registrate.LCItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistries;

public class LCEffects {
    public static final List<RegistryEntry<? extends Potion>> POTION_LIST = new ArrayList<RegistryEntry<? extends Potion>>();
    public static final Map<String, String> NAME_CACHE = new HashMap<String, String>();
    public static final RegistryEntry<EmeraldPopeEffect> EMERALD = LCEffects.genEffect("emerald_splash", () -> new EmeraldPopeEffect(MobEffectCategory.NEUTRAL, 65280), "Attack all surrounding enemies. Damage is based on currently player stats and weapons.");
    public static final RegistryEntry<FlameEffect> FLAME = LCEffects.genEffect("flame", "Soul Burning", () -> new FlameEffect(MobEffectCategory.HARMFUL, 0xFF0000), "Continuously damage the entity. Bypass fire resistance, but fire-based mobs are immune to this.");
    public static final RegistryEntry<IceEffect> ICE = LCEffects.genEffect("frozen", "Frost", () -> new IceEffect(MobEffectCategory.HARMFUL, 0x7F7FFF), "Slow down entity, and freeze them as if they are on powdered snow.");
    public static final RegistryEntry<ArmorReduceEffect> ARMOR_REDUCE = LCEffects.genEffect("armor_reduce", "Armor Corrosion", () -> new ArmorReduceEffect(MobEffectCategory.HARMFUL, 0xFFFFFF), "Reduce armor value significantly.");
    public static final RegistryEntry<StoneCageEffect> STONE_CAGE = LCEffects.genEffect("stone_cage", "Incarceration", () -> new StoneCageEffect(MobEffectCategory.HARMFUL, 0), "Immobilize the entity. Making it cannot move and unaffected by external forces.");
    public static final RegistryEntry<CurseEffect> CURSE = LCEffects.genEffect("curse", "Cursed", () -> new CurseEffect(MobEffectCategory.HARMFUL, 0x3F3F3F), "Make the entity cannot heal.");
    public static final RegistryEntry<BleedEffect> BLEED = LCEffects.genEffect("bleed", "Bleed", () -> new BleedEffect(MobEffectCategory.HARMFUL, 0x7F0000), "Make the entity lose attack and speed, and damage the entity every 3 seconds. Stacks when applied.");
    public static final RegistryEntry<CleanseEffect> CLEANSE = LCEffects.genEffect("cleanse", "Cleansed", () -> new CleanseEffect(MobEffectCategory.NEUTRAL, 0xFFFF7F), "Clear all potion effects and make the entity immune to potion effects.");
    private static final List<Runnable> TEMP = new ArrayList<Runnable>();

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)L2Complements.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, String lang, NonNullSupplier<T> sup, String desc) {
        NAME_CACHE.put(name, lang);
        return ((NoConfigBuilder)L2Complements.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_, lang)).register();
    }

    public static void registerBrewingRecipe() {
        TEMP.forEach(Runnable::run);
    }

    public static void register() {
        LCEffects.regPotion3("flame", () -> FLAME.get(), () -> LCItems.SOUL_FLAME.get(), 400, 600, 1000, 0, 1);
        LCEffects.regPotion2("frozen", () -> ICE.get(), () -> LCItems.HARD_ICE.get(), 3600, 9600);
        LCEffects.regPotion2("stone_cage", () -> STONE_CAGE.get(), () -> LCItems.BLACKSTONE_CORE.get(), 1200, 3600);
        LCEffects.regPotion2("curse", () -> CURSE.get(), () -> LCItems.CURSED_DROPLET.get(), 3600, 9600);
        LCEffects.regPotion2("cleanse", () -> CLEANSE.get(), () -> LCItems.LIFE_ESSENCE.get(), 3600, 9600);
        LCEffects.regPotion3("armor_reduce", () -> ARMOR_REDUCE.get(), 600, 1200, 3600, 0, 1, () -> Items.f_42542_, Potions.f_43593_, Potions.f_43594_, null, () -> Items.f_42592_, Potions.f_43610_, Potions.f_43611_, null);
        LCEffects.regPotion2("levitation", () -> MobEffects.f_19620_, () -> LCItems.CAPTURED_BULLET.get(), 200, 600);
        LCEffects.regPotion3("resistance", () -> MobEffects.f_19606_, () -> LCItems.EXPLOSION_SHARD.get(), 400, 600, 1200, 1, 2);
        LCEffects.regEmeraldPotion(() -> EMERALD.get(), () -> LCItems.EMERALD.get());
    }

    private static <T extends Potion> RegistryEntry<T> genPotion(String name, NonNullSupplier<T> sup) {
        RegistryEntry ans = ((NoConfigBuilder)L2Complements.REGISTRATE.entry(name, cb -> new NoConfigBuilder((AbstractRegistrate)L2Complements.REGISTRATE, (Object)L2Complements.REGISTRATE, name, cb, ForgeRegistries.Keys.POTIONS, sup))).register();
        POTION_LIST.add((RegistryEntry<? extends Potion>)ans);
        return ans;
    }

    private static void regPotion2(String id, Supplier<MobEffect> sup, Supplier<Item> item, int dur, int durLong) {
        RegistryEntry potion = LCEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur)}));
        RegistryEntry longPotion = LCEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
        });
    }

    private static void regPotion3(String id, Supplier<MobEffect> sup, Supplier<Item> item, int durStrong, int dur, int durLong, int amp, int ampStrong) {
        RegistryEntry potion = LCEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur, amp)}));
        RegistryEntry longPotion = LCEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong, amp)}));
        RegistryEntry strongPotion = LCEffects.genPotion("strong_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durStrong, ampStrong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42525_, (Potion)((Potion)strongPotion.get()));
        });
    }

    private static void regPotion3(String id, Supplier<MobEffect> sup, int durStrong, int dur, int durLong, int amp, int ampStrong, Supplier<Item> a, Potion ap, Potion lap, @Nullable Potion sap, Supplier<Item> b, Potion bp, Potion lbp, @Nullable Potion sbp) {
        RegistryEntry potion = LCEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur, amp)}));
        RegistryEntry longPotion = LCEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong, amp)}));
        RegistryEntry strongPotion = LCEffects.genPotion("strong_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durStrong, ampStrong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42525_, (Potion)((Potion)strongPotion.get()));
            PotionBrewing.m_43513_((Potion)ap, (Item)((Item)a.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)lap, (Item)((Item)a.get()), (Potion)((Potion)longPotion.get()));
            PotionBrewing.m_43513_((Potion)bp, (Item)((Item)b.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)lbp, (Item)((Item)b.get()), (Potion)((Potion)longPotion.get()));
            if (sap != null) {
                PotionBrewing.m_43513_((Potion)sap, (Item)((Item)a.get()), (Potion)((Potion)strongPotion.get()));
            }
            if (sbp != null) {
                PotionBrewing.m_43513_((Potion)sbp, (Item)((Item)b.get()), (Potion)((Potion)strongPotion.get()));
            }
        });
    }

    private static void regEmeraldPotion(Supplier<MobEffect> sup, Supplier<Item> item) {
        RegistryEntry potion = LCEffects.genPotion("emerald_splash", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), 1200, 0)}));
        RegistryEntry longPotion = LCEffects.genPotion("long_emerald_splash", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), 2400, 0)}));
        RegistryEntry strongPotion = LCEffects.genPotion("strong_emerald_splash", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), 1200, 1)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)((Item)LCItems.FORCE_FIELD.get()), (Potion)((Potion)longPotion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)((Item)LCItems.RESONANT_FEATHER.get()), (Potion)((Potion)strongPotion.get()));
        });
    }
}

