/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init;

import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2complements.compat.forbidden.FaARecipe;
import dev.xkmc.l2complements.content.enchantment.special.SoulBoundPlayerData;
import dev.xkmc.l2complements.content.item.misc.FireChargeItem;
import dev.xkmc.l2complements.content.item.wand.WandEffectToClient;
import dev.xkmc.l2complements.events.L2ComplementsClick;
import dev.xkmc.l2complements.events.MaterialDamageListener;
import dev.xkmc.l2complements.init.data.DamageTypeGen;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCConfigGen;
import dev.xkmc.l2complements.init.data.LCDatapackRegistriesGen;
import dev.xkmc.l2complements.init.data.LCSpriteSourceProvider;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2complements.init.data.RecipeGen;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2complements.init.registrate.LCBlocks;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2complements.init.registrate.LCEntities;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2complements.init.registrate.LCParticle;
import dev.xkmc.l2complements.init.registrate.LCRecipes;
import dev.xkmc.l2complements.network.EmptyRightClickToServer;
import dev.xkmc.l2complements.network.RotateDiggerToServer;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.GenItemVanillaType;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2screentracker.click.quickaccess.DefaultQuickAccessActions;
import dev.xkmc.l2screentracker.compat.arclight.AnvilMenuArclight;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2complements")
@Mod.EventBusSubscriber(modid="l2complements", bus=Mod.EventBusSubscriber.Bus.MOD)
public class L2Complements {
    public static final String MODID = "l2complements";
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig(new ResourceLocation("l2complements", "main"), 4, new Function[]{e -> e.create(EmptyRightClickToServer.class, NetworkDirection.PLAY_TO_SERVER), e -> e.create(RotateDiggerToServer.class, NetworkDirection.PLAY_TO_SERVER), e -> e.create(WandEffectToClient.class, NetworkDirection.PLAY_TO_CLIENT)});
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("l2complements");
    public static final GenItemVanillaType MATS = new GenItemVanillaType("l2complements", REGISTRATE);

    public L2Complements() {
        ForgeMod.enableMilkFluid();
        LCItems.register();
        LCBlocks.register();
        LCEffects.register();
        LCParticle.register();
        LCEnchantments.register();
        LCEntities.register();
        LCRecipes.register();
        LCConfig.init();
        SoulBoundPlayerData.register();
        DamageTypeGen.register();
        new L2ComplementsClick(new ResourceLocation(MODID, "main"));
        AttackEventHandler.register((int)5000, (AttackListener)new MaterialDamageListener());
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LCEffects.registerBrewingRecipe();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)LCItems.SOUL_CHARGE.get()), (DispenseItemBehavior)(FireChargeItem)((Object)((Object)LCItems.SOUL_CHARGE.get())).new FireChargeItem.FireChargeBehavior());
            DispenserBlock.m_52672_((ItemLike)((ItemLike)LCItems.STRONG_CHARGE.get()), (DispenseItemBehavior)(FireChargeItem)((Object)((Object)LCItems.STRONG_CHARGE.get())).new FireChargeItem.FireChargeBehavior());
            DispenserBlock.m_52672_((ItemLike)((ItemLike)LCItems.BLACK_CHARGE.get()), (DispenseItemBehavior)(FireChargeItem)((Object)((Object)LCItems.BLACK_CHARGE.get())).new FireChargeItem.FireChargeBehavior());
            DefaultQuickAccessActions.quickAccess((MenuType)MenuType.f_39964_, (Item)LCBlocks.ETERNAL_ANVIL.m_5456_(), AnvilMenuArclight::new, (String)"container.repair");
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, TagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(TagGen.EFF_TAGS, TagGen::onEffectTagGen);
        REGISTRATE.addDataGenerator(TagGen.ENCH_TAGS, TagGen::onEnchTagGen);
        boolean run = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(run, (DataProvider)new LCConfigGen(gen));
        gen.addProvider(run, (DataProvider)new LCSpriteSourceProvider(output, helper));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void gatherDataAfter(GatherDataEvent event) {
        boolean run = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        new DamageTypeGen(output, pvd, helper).generate(run, gen);
        RegistrySetBuilder data = new RegistrySetBuilder().m_254916_(Registries.f_266076_, ctx -> Arrays.stream(LCMats.values()).forEach(e -> ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation(MODID, e.getID())), (Object)TrimMaterial.m_267605_((String)e.getID(), (Item)e.getIngot(), (float)0.0f, (Component)e.getIngot().m_41466_().m_6881_().m_130940_(e.trim_text_color), Map.of()))));
        gen.addProvider(run, (DataProvider)new LCDatapackRegistriesGen(output, pvd, data, "L2Complements Data"));
        if (ModList.get().isLoaded("forbidden_arcanus")) {
            gen.addProvider(run, (DataProvider)new LCDatapackRegistriesGen(output, pvd, new RegistrySetBuilder().m_254916_(FARegistries.RITUAL, FaARecipe::gather), "Forbidden and Arcanus Data"));
        }
    }
}

