/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.content.enchantment.core.SourceModifierEnchantment;
import dev.xkmc.l2complements.content.enchantment.weapon.VoidTouchEnchantment;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import java.util.HashSet;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.ModList;

public class MaterialDamageListener
implements AttackListener {
    public static final HashSet<String> BAN_SPACE_SHARD = new HashSet();

    public static boolean isSpaceShardBanned() {
        if (((Boolean)LCConfig.COMMON.allowModBanSpaceShard.get()).booleanValue()) {
            for (String e : BAN_SPACE_SHARD) {
                if (!ModList.get().isLoaded(e)) continue;
                return true;
            }
        }
        return false;
    }

    public void onCreateSource(CreateSourceEvent event) {
        if (event.getOriginal().equals((Object)DamageTypes.f_268566_) || event.getOriginal().equals((Object)DamageTypes.f_268464_)) {
            ItemStack stack = event.getAttacker().m_21205_();
            SourceModifierEnchantment.modifySource(stack, event);
        }
    }

    public void onDamageFinalized(AttackCache cache, ItemStack weapon) {
        LivingDamageEvent event = cache.getLivingDamageEvent();
        if (event == null) {
            return;
        }
        LivingEntity livingEntity = cache.getAttackTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float damage = cache.getPreDamage();
            if (event.getSource().m_269533_(DamageTypeTags.f_268415_) && damage >= (float)((Integer)LCConfig.COMMON.explosionDamage.get()).intValue() && cache.getDamageDealt() < player.m_21223_() + player.m_6103_()) {
                player.m_150109_().m_150079_(LCItems.EXPLOSION_SHARD.asStack());
            }
        }
        if ((livingEntity = cache.getAttackTarget()) instanceof Chicken) {
            Chicken chicken = (Chicken)livingEntity;
            if (event.getSource().m_19385_().equals("sonic_boom") && cache.getDamageDealt() < chicken.m_21223_() + chicken.m_6103_()) {
                chicken.m_19983_(LCItems.RESONANT_FEATHER.asStack());
            }
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_) && event.getSource().m_7639_() instanceof Player && !MaterialDamageListener.isSpaceShardBanned() && cache.getPreDamage() >= (float)((Integer)LCConfig.COMMON.spaceDamage.get()).intValue()) {
            cache.getAttackTarget().m_19983_(LCItems.SPACE_SHARD.asStack());
        }
    }

    public void postAttack(AttackCache cache, LivingAttackEvent event, ItemStack weapon) {
        if (!weapon.m_41619_()) {
            ((VoidTouchEnchantment)LCEnchantments.VOID_TOUCH.get()).postAttack(cache, event, weapon);
        }
    }

    public void onHurt(AttackCache cache, ItemStack weapon) {
        if (!weapon.m_41619_()) {
            ((VoidTouchEnchantment)LCEnchantments.VOID_TOUCH.get()).initAttack(cache, weapon);
        }
    }

    public void postHurt(AttackCache cache, LivingHurtEvent event, ItemStack weapon) {
        if (!weapon.m_41619_()) {
            ((VoidTouchEnchantment)LCEnchantments.VOID_TOUCH.get()).postHurt(cache, event, weapon);
        }
    }

    public void onDamage(AttackCache cache, ItemStack weapon) {
        if (!weapon.m_41619_()) {
            ((VoidTouchEnchantment)LCEnchantments.VOID_TOUCH.get()).initDamage(cache, weapon);
        }
    }

    static {
        BAN_SPACE_SHARD.add("l2artifacts");
        BAN_SPACE_SHARD.add("l2hostility");
        BAN_SPACE_SHARD.add("apotheosis");
    }
}

