/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.compat.CurioCompat;
import dev.xkmc.l2complements.content.effect.skill.CleanseEffect;
import dev.xkmc.l2complements.content.effect.skill.SkillEffect;
import dev.xkmc.l2complements.content.enchantment.core.AttributeEnchantment;
import dev.xkmc.l2complements.content.enchantment.digging.DiggerHelper;
import dev.xkmc.l2complements.content.enchantment.digging.RangeDiggingEnchantment;
import dev.xkmc.l2complements.content.enchantment.special.SoulBoundPlayerData;
import dev.xkmc.l2complements.content.feature.EntityFeature;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.base.effects.ForceAddEffectEvent;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(modid="l2complements", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MagicEventHandler {
    private static List<BooleanSupplier> TASKS = new ArrayList<BooleanSupplier>();

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        OwnableEntity ownable;
        Entity entity;
        if (EntityFeature.OWNER_PROTECTION.test(event.getEntity()) && (entity = event.getSource().m_7639_()) instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() == event.getEntity()) {
            event.setCanceled(true);
        }
        if (!((Boolean)LCConfig.COMMON.enableImmunityEnchantments.get()).booleanValue()) {
            return;
        }
        if (EntityFeature.INVINCIBLE.test(event.getEntity())) {
            event.setCanceled(true);
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268437_) || event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
            return;
        }
        if (EntityFeature.ENVIRONMENTAL_REJECT.test(event.getEntity()) && event.getSource().m_7639_() == null) {
            event.setCanceled(true);
        }
        if (EntityFeature.MAGIC_REJECT.test(event.getEntity()) && event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
            event.setCanceled(true);
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268413_)) {
            return;
        }
        if (EntityFeature.PROJECTILE_REJECT.test(event.getEntity()) && event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            event.setCanceled(true);
        }
        if (EntityFeature.FIRE_REJECT.test(event.getEntity()) && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
            event.setCanceled(true);
        }
        if (EntityFeature.EXPLOSION_REJECT.test(event.getEntity()) && event.getSource().m_269533_(DamageTypeTags.f_268415_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_6060_() && EntityFeature.FIRE_REJECT.test(event.getEntity())) {
            event.getEntity().m_20095_();
        }
    }

    @SubscribeEvent
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41793_()) {
            for (Map.Entry ent : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                Object k = ent.getKey();
                if (!(k instanceof AttributeEnchantment)) continue;
                AttributeEnchantment attr = (AttributeEnchantment)k;
                attr.addAttributes((Integer)ent.getValue(), event);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInventoryDrop(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        event.getDrops().removeIf(e -> e.m_32055_().getEnchantmentLevel((Enchantment)LCEnchantments.SOUL_BOUND.get()) > 0 && SoulBoundPlayerData.addToPlayer(player, e.m_32055_()));
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)LCEffects.CURSE.get())) {
            event.setCanceled(true);
            return;
        }
        float amount = event.getAmount();
        for (ItemStack stack : CurioCompat.getAllSlots(event.getEntity())) {
            int lv;
            if (!stack.m_41793_() || !stack.m_41768_() || (lv = stack.getEnchantmentLevel((Enchantment)LCEnchantments.LIFE_MENDING.get())) <= 0) continue;
            int damage = stack.m_41773_();
            int repair = 1 << lv - 1;
            int armor = stack.getEnchantmentLevel((Enchantment)LCEnchantments.DURABLE_ARMOR.get());
            if (armor > 0) {
                repair *= 1 + armor;
            }
            int recover = Math.min(damage, (int)Math.floor(amount * (float)repair));
            stack.m_41721_(damage - recover);
            if (!((double)(amount -= 1.0f * (float)recover / (float)repair) < 0.001)) continue;
            break;
        }
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void onTeleport(EntityTeleportEvent event) {
        LivingEntity le;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).m_21023_((MobEffect)LCEffects.STONE_CAGE.get())) {
            event.setCanceled(true);
        }
    }

    public static boolean isSkill(MobEffectInstance ins, LivingEntity entity) {
        if (ins.m_19544_() instanceof SkillEffect) {
            return true;
        }
        if (EffectUtil.getReason() == EffectUtil.AddReason.SKILL) {
            return true;
        }
        int pred = (Integer)LCConfig.COMMON.cleansePredicate.get();
        if (ins.m_19544_().m_19486_() && pred > 0) {
            return true;
        }
        if (ins.m_19544_().m_19483_() == MobEffectCategory.NEUTRAL && pred > 1) {
            return true;
        }
        ITagManager tag = ForgeRegistries.MOB_EFFECTS.tags();
        if (tag != null && tag.getTag(TagGen.SKILL_EFFECT).contains((Object)ins.m_19544_())) {
            return true;
        }
        return CurioCompat.testEffect(ins, entity);
    }

    @SubscribeEvent
    public static void onPotionTest(MobEffectEvent.Applicable event) {
        if (event.getEntity().m_21023_((MobEffect)LCEffects.CLEANSE.get())) {
            if (MagicEventHandler.isSkill(event.getEffectInstance(), event.getEntity())) {
                return;
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onForceAdd(ForceAddEffectEvent event) {
        if (event.getEntity().m_21023_((MobEffect)LCEffects.CLEANSE.get())) {
            if (MagicEventHandler.isSkill(event.getEffectInstance(), event.getEntity())) {
                return;
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPotionAdded(MobEffectEvent.Added event) {
        if (event.getEntity().m_21023_((MobEffect)LCEffects.CLEANSE.get())) {
            if (MagicEventHandler.isSkill(event.getEffectInstance(), event.getEntity())) {
                return;
            }
            GeneralEventHandler.schedule(() -> CleanseEffect.clearOnEntity(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = player2.m_21205_();
        Pair<RangeDiggingEnchantment, Integer> ent = DiggerHelper.getDigger(stack);
        if (ent == null) {
            return;
        }
        ((RangeDiggingEnchantment)ent.getFirst()).onBlockBreak(player2, event.getPos(), stack, Math.min(((RangeDiggingEnchantment)ent.getFirst()).m_6586_(), (Integer)ent.getSecond()));
    }

    @Deprecated(forRemoval=true)
    public static synchronized void schedule(Runnable runnable) {
        TASKS.add(() -> {
            runnable.run();
            return true;
        });
    }

    @Deprecated(forRemoval=true)
    public static synchronized void schedulePersistent(BooleanSupplier runnable) {
        TASKS.add(runnable);
    }

    private static synchronized void execute() {
        if (TASKS.isEmpty()) {
            return;
        }
        List<BooleanSupplier> temp = TASKS;
        TASKS = new ArrayList<BooleanSupplier>();
        temp.removeIf(BooleanSupplier::getAsBoolean);
        temp.addAll(TASKS);
        TASKS = temp;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        MagicEventHandler.execute();
    }
}

