/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandItem;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SonicShooter
extends WandItem
implements IGlowingTarget {
    private static final int RANGE = 17;

    public SonicShooter(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.m_5776_() && selected && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)17.0);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        player.m_5496_(SoundEvents.f_215772_, 3.0f, 1.0f);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (user instanceof Player) {
                Vec3 src = user.m_146892_();
                Vec3 dst = RayTraceUtil.getRayTerm((Vec3)src, (float)user.m_146909_(), (float)user.m_146908_(), (double)17.0);
                Vec3 dir = dst.m_82546_(src).m_82541_();
                SonicShooter.shoot(sl, user, stack, src, dir);
            }
        }
        return stack;
    }

    public static void shoot(ServerLevel level, LivingEntity user, ItemStack stack, Vec3 src, Vec3 dir) {
        for (int i = 1; i < 17; ++i) {
            Vec3 vec33 = src.m_82549_(dir.m_82490_((double)i));
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        ArrayList<LivingEntity> target = new ArrayList<LivingEntity>();
        AABB aabb = new AABB(src, src.m_82549_(dir.m_82490_(17.0)));
        block1: for (Entity entity : level.m_45933_((Entity)user, aabb)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity x = (LivingEntity)entity;
            AABB box = x.m_20191_().m_82400_(1.0);
            for (int i = 0; i <= 17; ++i) {
                if (!box.m_82390_(src.m_82549_(dir.m_82490_((double)i)))) continue;
                target.add(x);
                continue block1;
            }
        }
        for (LivingEntity livingEntity : target) {
            livingEntity.m_6469_(level.m_269111_().m_269285_((Entity)user), (float)((Integer)LCConfig.COMMON.sonicShooterDamage.get()).intValue());
            double d1 = 0.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            double d0 = 2.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            livingEntity.m_5997_(dir.m_7096_() * d0, dir.m_7098_() * d1, dir.m_7094_() * d0);
        }
        user.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
        stack.m_41622_(1, user, e -> e.m_21190_(e.m_7655_()));
    }

    public int m_8105_(ItemStack stack) {
        return 34;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getDistance(ItemStack itemStack) {
        return 17;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.IDS.SONIC_SHOOTER.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
    }
}

