/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.misc;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2library.util.nbt.NBTObj;
import dev.xkmc.l2library.util.tools.TeleportTool;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WarpStone
extends Item {
    public final boolean fragile;

    public static Optional<Pair<ResourceKey<Level>, Vec3>> getPos(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(e -> e.m_128441_("pos")).map(e -> e.m_128469_("pos")).map(e -> Pair.of((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(e.m_128461_("dim"))), (Object)new Vec3(e.m_128459_("x"), e.m_128459_("y"), e.m_128459_("z"))));
    }

    public static void setPos(ItemStack stack, Level level, double x, double y, double z) {
        CompoundTag tag = new NBTObj((CompoundTag)stack.m_41784_()).getSub((String)"pos").tag;
        tag.m_128359_("dim", level.m_46472_().m_135782_().toString());
        tag.m_128347_("x", x);
        tag.m_128347_("y", y);
        tag.m_128347_("z", z);
    }

    public WarpStone(Item.Properties props, boolean fragile) {
        super(props);
        this.fragile = fragile;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return this.use(level, player, stack, e -> e.m_21190_(hand));
    }

    public void use(ServerPlayer player, ItemStack stack) {
        this.use(player.m_9236_(), (Player)player, stack, e -> {});
    }

    private InteractionResultHolder<ItemStack> use(Level level, Player player, ItemStack stack, Consumer<Player> breaker) {
        Optional<Pair<ResourceKey<Level>, Vec3>> ppos = WarpStone.getPos(stack);
        if (ppos.isPresent()) {
            if (!level.m_5776_()) {
                Pair<ResourceKey<Level>, Vec3> pair = ppos.get();
                ResourceKey dim = (ResourceKey)pair.getFirst();
                Vec3 pos = (Vec3)pair.getSecond();
                ServerLevel lv = ((ServerLevel)level).m_7654_().m_129880_(dim);
                if (lv != null) {
                    TeleportTool.performTeleport((Entity)player, (ServerLevel)lv, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (float)player.m_146908_(), (float)player.m_146909_());
                }
                if (!this.fragile) {
                    stack.m_41622_(1, (LivingEntity)player, breaker);
                }
            }
            if (this.fragile) {
                stack.m_41774_(1);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!level.m_5776_()) {
            WarpStone.setPos(stack, level, player.m_20185_(), player.m_20186_() + 0.001, player.m_20189_());
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        int dur;
        Optional<Pair<ResourceKey<Level>, Vec3>> pos = WarpStone.getPos(stack);
        int n = dur = this.fragile ? 1 : stack.m_41776_() - this.getDamage(stack);
        if (pos.isPresent()) {
            Pair<ResourceKey<Level>, Vec3> cpos = pos.get();
            MutableComponent clevel = Component.m_237115_((String)((ResourceKey)cpos.getFirst()).m_135782_().toString());
            Vec3 bpos = (Vec3)cpos.getSecond();
            list.add((Component)LangData.IDS.WARP_POS.get(clevel, Math.round(bpos.f_82479_), Math.round(bpos.f_82480_), Math.round(bpos.f_82479_)).m_130940_(ChatFormatting.GRAY));
            list.add((Component)LangData.IDS.WARP_TELEPORT.get(dur).m_130940_(ChatFormatting.GRAY));
            if (!this.fragile) {
                list.add((Component)LangData.IDS.WARP_GRIND.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)LangData.IDS.WARP_RECORD.get(dur).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return WarpStone.getPos(pStack).isPresent();
    }
}

