/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.equipments;

import com.google.common.collect.Multimap;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraArmorConfig;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class PoseiditeArmor
extends ExtraArmorConfig {
    private static final String KEY = "UserInWater";
    private static final String NAME_ARMOR = "neptunium_armor";
    private static final String NAME_TOUGH = "neptunium_toughness";
    private static final String NAME_SPEED = "neptunium_speed";
    private static final String NAME_SWIM = "neptunium_swim";
    private static final AttributeModifier[] ARMOR = PoseiditeArmor.makeModifiers("neptunium_armor", 4.0, 6.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier[] TOUGH = PoseiditeArmor.makeModifiers("neptunium_toughness", 2.0, 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier[] SPEED = PoseiditeArmor.makeModifiers("neptunium_speed", 0.1, 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier[] SWIM = PoseiditeArmor.makeModifiers("neptunium_swim", 0.1, 0.15, AttributeModifier.Operation.MULTIPLY_BASE);

    private static AttributeModifier[] makeModifiers(String name, double val, double val2, AttributeModifier.Operation op) {
        AttributeModifier[] ans = new AttributeModifier[4];
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
            double v = slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS ? val2 : val;
            String str = name + "/" + slot.m_20751_().toLowerCase(Locale.ROOT);
            ans[i] = new AttributeModifier(MathHelper.getUUIDFromString((String)str), str, v, op);
        }
        return ans;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        stack.m_41784_().m_128379_(KEY, player.m_20071_());
        if (!player.m_20071_()) {
            return;
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)stack);
        if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST) {
            EffectUtil.refreshEffect((LivingEntity)player, (MobEffectInstance)new MobEffectInstance(MobEffects.f_19592_, 200), (EffectUtil.AddReason)EffectUtil.AddReason.SELF, (Entity)player);
        }
        if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
            EffectUtil.refreshEffect((LivingEntity)player, (MobEffectInstance)new MobEffectInstance(MobEffects.f_19593_, 200), (EffectUtil.AddReason)EffectUtil.AddReason.SELF, (Entity)player);
        }
    }

    public Multimap<Attribute, AttributeModifier> modify(Multimap<Attribute, AttributeModifier> map, EquipmentSlot slot, ItemStack stack) {
        if (stack.m_41784_().m_128471_(KEY)) {
            map.put((Object)Attributes.f_22284_, (Object)ARMOR[slot.m_20749_()]);
            map.put((Object)Attributes.f_22285_, (Object)TOUGH[slot.m_20749_()]);
            map.put((Object)Attributes.f_22279_, (Object)SPEED[slot.m_20749_()]);
        }
        map.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)SWIM[slot.m_20749_()]);
        return map;
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        list.add((Component)LangData.IDS.POSEIDITE_ARMOR.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        super.addTooltip(stack, list);
    }
}

