/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.digging;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.content.enchantment.digging.RangeDiggingEnchantment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DiggerHelper {
    private static final String KEY = "l2complements:selected_digger";

    @Nullable
    public static Pair<RangeDiggingEnchantment, Integer> getDigger(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41793_()) {
            return null;
        }
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return null;
        }
        String str = root.m_128461_(KEY);
        if (!ResourceLocation.m_135830_((String)str)) {
            return null;
        }
        Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(str));
        if (!(e instanceof RangeDiggingEnchantment)) {
            return null;
        }
        RangeDiggingEnchantment ench = (RangeDiggingEnchantment)e;
        int lv = stack.getEnchantmentLevel(e);
        if (lv <= 0) {
            return null;
        }
        return Pair.of((Object)ench, (Object)lv);
    }

    public static void rotateDigger(ItemStack stack, boolean reverse) {
        Pair<RangeDiggingEnchantment, Integer> current = DiggerHelper.getDigger(stack);
        List<Object> list = new ArrayList(stack.getAllEnchantments().keySet());
        if (reverse) {
            list = Lists.reverse(list);
        }
        for (Enchantment ent : list) {
            if (!(ent instanceof RangeDiggingEnchantment)) continue;
            RangeDiggingEnchantment ench = (RangeDiggingEnchantment)ent;
            if (current == null) {
                ResourceLocation rl = ForgeRegistries.ENCHANTMENTS.getKey((Object)ench);
                assert (rl == null);
                stack.m_41784_().m_128359_(KEY, rl.toString());
                return;
            }
            if (ench != current.getFirst()) continue;
            current = null;
        }
        stack.m_41784_().m_128473_(KEY);
    }
}

