/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.core;

import dev.xkmc.l2complements.content.enchantment.core.CraftableEnchantment;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2library.base.L2Registrate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class UnobtainableEnchantment
extends Enchantment
implements CraftableEnchantment {
    private static final List<UnobtainableEnchantment> CACHE = new ArrayList<UnobtainableEnchantment>();

    public static ItemStack makeBook(Enchantment ench, int level) {
        return EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(ench, level));
    }

    public static void injectTab(L2Registrate reg, EnchantmentCategory ... cats) {
        reg.modifyCreativeModeTab(LCItems.TAB_ENCHMIN.getKey(), m -> {
            Set<EnchantmentCategory> set = Set.of(cats);
            UnobtainableEnchantment.getSorted().stream().filter(e -> e.allowedInCreativeTab(Items.f_42690_, set)).forEach(e -> e.getCraftableLevels().forEach(i -> m.m_246267_(UnobtainableEnchantment.makeBook(e, i), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY)));
        });
        reg.modifyCreativeModeTab(LCItems.TAB_ENCHMAX.getKey(), m -> {
            Set<EnchantmentCategory> set = Set.of(cats);
            UnobtainableEnchantment.getSorted().stream().filter(e -> e.allowedInCreativeTab(Items.f_42690_, set)).forEach(e -> m.m_246267_(UnobtainableEnchantment.makeBook(e, e.m_6586_()), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY));
        });
    }

    private static List<UnobtainableEnchantment> getSorted() {
        TreeMap<String, List> map = new TreeMap<String, List>();
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (UnobtainableEnchantment e : CACHE) {
            ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
            assert (id != null);
            map.computeIfAbsent(id.m_135827_(), k -> new ArrayList()).add(e);
        }
        ids.add("l2complements");
        ids.addAll(map.keySet());
        ArrayList<UnobtainableEnchantment> ans = new ArrayList<UnobtainableEnchantment>();
        for (String s : ids) {
            ans.addAll((Collection)map.get(s));
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnobtainableEnchantment(Enchantment.Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot[] pApplicableSlots) {
        super(pRarity, pCategory, pApplicableSlots);
        List<UnobtainableEnchantment> list = CACHE;
        synchronized (list) {
            CACHE.add(this);
        }
    }

    public int m_6183_(int lv) {
        return 5;
    }

    public int m_6175_(int lv) {
        return 1;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public ChatFormatting getColor() {
        return ChatFormatting.GREEN;
    }

    public Component m_44700_(int lv) {
        MutableComponent component = Component.m_237115_((String)this.m_44704_());
        if (lv != 1 || this.m_6586_() != 1) {
            component.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + lv)));
        }
        component.m_130940_(this.getColor());
        return component;
    }

    public boolean allowedInCreativeTab(Item book, Set<EnchantmentCategory> tab) {
        return tab.contains(LCEnchantments.ALL);
    }

    public int getDecoColor(String s) {
        if (s.equals("A")) {
            return -32769;
        }
        if (s.equals("W")) {
            return -8433809;
        }
        if (this.f_44672_ == LCEnchantments.ALL) {
            return -24753;
        }
        return switch (this.f_44672_) {
            case EnchantmentCategory.ARMOR -> -11550721;
            case EnchantmentCategory.WEAPON -> -45233;
            case EnchantmentCategory.BREAKABLE -> -8388737;
            default -> -129;
        };
    }
}

