/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.effect.skill;

import dev.xkmc.l2complements.init.data.DamageTypeGen;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCParticle;
import dev.xkmc.l2library.base.effects.api.ClientRenderEffect;
import dev.xkmc.l2library.base.effects.api.DelayedEntityRender;
import dev.xkmc.l2library.base.effects.api.FirstPlayerRenderEffect;
import dev.xkmc.l2library.util.Proxy;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmeraldPopeEffect
extends MobEffect
implements FirstPlayerRenderEffect,
ClientRenderEffect {
    public EmeraldPopeEffect(MobEffectCategory type, int color) {
        super(type, color);
    }

    public void m_6742_(LivingEntity self, int level) {
        if (self.m_9236_().m_5776_()) {
            return;
        }
        int radius = (level + 1) * (Integer)LCConfig.COMMON.emeraldBaseRange.get();
        AttributeInstance atk = self.m_21051_(Attributes.f_22281_);
        int damage = (int)((Double)LCConfig.COMMON.emeraldDamageFactor.get() * (atk == null ? 1.0 : atk.m_22135_()));
        DamageSource source = new DamageSource(DamageTypeGen.forKey(self.m_9236_(), DamageTypeGen.EMERALD), null, (Entity)self);
        for (Entity e : self.m_9236_().m_45933_((Entity)self, new AABB(self.m_20183_()).m_82400_((double)radius))) {
            if (!(e instanceof Enemy) || e.m_7307_((Entity)self) || ((LivingEntity)e).f_20916_ != 0 || !(e.m_20182_().m_82557_(self.m_20182_()) < (double)(radius * radius))) continue;
            double dist = e.m_20182_().m_82554_(self.m_20182_());
            if (dist > 0.1) {
                ((LivingEntity)e).m_147240_((double)0.4f, e.m_20182_().f_82479_ - self.m_20182_().f_82479_, e.m_20182_().f_82481_ - self.m_20182_().f_82481_);
            }
            e.m_6469_(source, (float)damage);
        }
    }

    public boolean m_6584_(int tick, int lv) {
        return tick % 10 == 0;
    }

    public void render(LivingEntity entity, int lv, Consumer<DelayedEntityRender> consumer) {
        if (entity == Proxy.getClientPlayer()) {
            return;
        }
        EmeraldPopeEffect.renderEffect(lv, (Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientLevelRender(AbstractClientPlayer player, MobEffectInstance ins) {
        EmeraldPopeEffect.renderEffect(ins.m_19564_(), (Entity)player);
    }

    private static void renderEffect(int lv, Entity entity) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        int r = (lv + 1) * (Integer)LCConfig.COMMON.emeraldBaseRange.get();
        int count = (1 + lv) * (1 + lv) * 4;
        for (int i = 0; i < count; ++i) {
            EmeraldPopeEffect.addParticle(entity.m_9236_(), entity.m_20182_(), r);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addParticle(Level w, Vec3 vec, int r) {
        float tpi = (float)Math.PI * 2;
        Vec3 v0 = new Vec3(0.0, (double)r, 0.0);
        Vec3 v1 = v0.m_82496_(tpi / 3.0f).m_82524_((float)(Math.random() * (double)tpi));
        float a0 = (float)(Math.random() * (double)tpi);
        float b0 = (float)Math.acos(2.0 * Math.random() - 1.0);
        v0 = v0.m_82496_(a0).m_82524_(b0);
        v1 = v1.m_82496_(a0).m_82524_(b0);
        w.m_7107_((ParticleOptions)LCParticle.EMERALD.get(), vec.f_82479_ + v0.f_82479_, vec.f_82480_ + v0.f_82480_, vec.f_82481_ + v0.f_82481_, vec.f_82479_ + v1.f_82479_, vec.f_82480_ + v1.f_82480_, vec.f_82481_ + v1.f_82481_);
    }
}

