/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.client;

import java.util.List;
import net.minecraft.core.BlockPos;

public class ClusterBitSet {
    private boolean[][][] data;
    private int x0;
    private int y0;
    private int z0;
    private int x1;
    private int y1;
    private int z1;
    private int dx;
    private int dy;
    private int dz;

    public static ClusterBitSet of(BlockPos center, List<BlockPos> list) {
        return new ClusterBitSet(center, list);
    }

    private ClusterBitSet(BlockPos center, List<BlockPos> list) {
        this.x0 = this.x1 = center.m_123341_();
        this.y0 = this.y1 = center.m_123342_();
        this.z0 = this.z1 = center.m_123343_();
        for (BlockPos e : list) {
            this.x0 = Math.min(this.x0, e.m_123341_());
            this.y0 = Math.min(this.y0, e.m_123342_());
            this.z0 = Math.min(this.z0, e.m_123343_());
            this.x1 = Math.max(this.x1, e.m_123341_());
            this.y1 = Math.max(this.y1, e.m_123342_());
            this.z1 = Math.max(this.z1, e.m_123343_());
        }
        this.dx = this.x1 - this.x0 + 1;
        this.dy = this.y1 - this.y0 + 1;
        this.dz = this.z1 - this.z0 + 1;
        this.data = new boolean[this.dx][this.dy][this.dz];
        this.putData(center);
        for (BlockPos e : list) {
            this.putData(e);
        }
    }

    private void putData(BlockPos pos) {
        this.data[pos.m_123341_() - this.x0][pos.m_123342_() - this.y0][pos.m_123343_() - this.z0] = true;
    }

    private boolean data(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.dx || y >= this.dy || z >= this.dz) {
            return false;
        }
        return this.data[x][y][z];
    }

    private boolean edge(boolean edge, boolean b00, boolean b01, boolean b10, boolean b11) {
        if (b00 && b01 && b10 && b11) {
            return false;
        }
        if (b00 && b01 && !b10 && !b11) {
            return !edge;
        }
        if (!b00 && !b01 && b10 && b11) {
            return !edge;
        }
        if (b00 & b10 && !b01 && !b11) {
            return !edge;
        }
        if (!b00 & !b10 && b01 && b11) {
            return !edge;
        }
        return b00 || b01 || b10 || b11;
    }

    public void render(boolean edge, Handle handle) {
        for (int x = 0; x <= this.dx; ++x) {
            for (int y = 0; y <= this.dy; ++y) {
                for (int z = 0; z <= this.dz; ++z) {
                    if (x < this.dx && this.edge(edge, this.data(x, y - 1, z - 1), this.data(x, y, z - 1), this.data(x, y - 1, z), this.data(x, y, z))) {
                        handle.render(this.x0 + x, this.y0 + y, this.z0 + z, this.x0 + x + 1, this.y0 + y, this.z0 + z);
                    }
                    if (y < this.dy && this.edge(edge, this.data(x - 1, y, z - 1), this.data(x, y, z - 1), this.data(x - 1, y, z), this.data(x, y, z))) {
                        handle.render(this.x0 + x, this.y0 + y, this.z0 + z, this.x0 + x, this.y0 + y + 1, this.z0 + z);
                    }
                    if (z >= this.dz || !this.edge(edge, this.data(x - 1, y - 1, z), this.data(x, y - 1, z), this.data(x - 1, y, z), this.data(x, y, z))) continue;
                    handle.render(this.x0 + x, this.y0 + y, this.z0 + z, this.x0 + x, this.y0 + y, this.z0 + z + 1);
                }
            }
        }
    }

    public static interface Handle {
        public void render(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

