/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.compat;

import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;

@ParametersAreNullableByDefault
public class TeamAccessor {
    public static final boolean PLAYER_HURT = false;

    public static boolean arePlayersInSameTeam(ServerPlayer a, ServerPlayer b) {
        if (a == null || b == null) {
            return false;
        }
        if (b.m_7307_((Entity)a) || a.m_7307_((Entity)b)) {
            return true;
        }
        return TeamAccessor.playerSameTeam(a.m_20148_(), b.m_20148_());
    }

    public static boolean arePlayerAndEntityInSameTeam(ServerPlayer a, LivingEntity b) {
        if (a == null || b == null) {
            return false;
        }
        if (b.m_7307_((Entity)a) || a.m_7307_((Entity)b)) {
            return true;
        }
        UUID bid = TeamAccessor.getPotentialOwner((Entity)b);
        return bid != null && TeamAccessor.playerSameTeam(a.m_20148_(), bid);
    }

    public static boolean areEntitiesInSameTeam(LivingEntity a, LivingEntity b) {
        if (a == null || b == null) {
            return false;
        }
        if (b.m_7307_((Entity)a) || a.m_7307_((Entity)b)) {
            return true;
        }
        UUID aid = TeamAccessor.getPotentialOwner((Entity)a);
        UUID bid = TeamAccessor.getPotentialOwner((Entity)b);
        if (aid != null && bid != null) {
            return TeamAccessor.playerSameTeam(aid, bid);
        }
        return false;
    }

    @Nullable
    public static UUID getPotentialOwner(Entity e) {
        if (e instanceof ServerPlayer) {
            return e.m_20148_();
        }
        if (e instanceof TamableAnimal) {
            TamableAnimal a = (TamableAnimal)e;
            return a.m_21805_();
        }
        return null;
    }

    private static boolean playerSameTeam(UUID a, UUID b) {
        return true;
    }

    private static boolean ftbSameTeamUnsafe(UUID a, UUID b) {
        return false;
    }
}

