/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.layout;

import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.HeaderComponent;
import dev.obscuria.tooltips.client.tooltip.element.panel.TooltipPanel;
import dev.obscuria.tooltips.client.tooltip.layout.TooltipLayout;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHeaderLayout<T extends TooltipState>
implements TooltipLayout<T> {
    @Override
    public List<ClientTooltipComponent> processPreWrap(T state, List<ClientTooltipComponent> components, Font font) {
        return this.makeHeader(state, components, font);
    }

    protected List<ClientTooltipComponent> makeHeader(T state, List<ClientTooltipComponent> components, Font font) {
        ClientTooltipComponent title = this.extractFirstText(components);
        if (title == null) {
            return components;
        }
        ClientTooltipComponent label = ((TooltipState)state).createLabel();
        components.add(0, new HeaderComponent((TooltipState)state, title, label, this.shouldDrawSeparator(components), this.pickSeparatorColor(state)));
        return components;
    }

    @Nullable
    private ClientTooltipComponent extractFirstText(List<ClientTooltipComponent> components) {
        for (int i = 0; i < components.size(); ++i) {
            if (!(components.get(i) instanceof ClientTextTooltip)) continue;
            return components.remove(i);
        }
        return null;
    }

    private boolean isZeroHeight(List<ClientTooltipComponent> components) {
        return components.stream().mapToInt(ClientTooltipComponent::m_142103_).sum() <= 0;
    }

    private boolean shouldDrawSeparator(List<ClientTooltipComponent> components) {
        return !components.isEmpty() && !this.isZeroHeight(components);
    }

    private ARGB pickSeparatorColor(T state) {
        return ((TooltipState)state).style.panel().map(TooltipPanel::separatorColor).orElse(TooltipPanel.DEFAULT_SEPARATOR_COLOR);
    }
}

