/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import dev.obscuria.tooltips.client.ParticleData;
import dev.obscuria.tooltips.client.component.BlankComponent;
import dev.obscuria.tooltips.client.tooltip.TooltipDefinition;
import dev.obscuria.tooltips.client.tooltip.TooltipLabel;
import dev.obscuria.tooltips.client.tooltip.TooltipStyle;
import dev.obscuria.tooltips.client.tooltip.element.SoundTemplate;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

public abstract class TooltipState {
    private static UUID lastIconSoundUuid = UUID.randomUUID();
    private static long lastIconSoundTime = 0L;
    public final ItemStack stack;
    public final TooltipStyle style;
    @Nullable
    public final TooltipLabel label;
    public final Long startTime;
    public final List<ParticleData> particles;
    public final UUID uuid = UUID.randomUUID();
    public boolean isFirstFrame = true;

    protected TooltipState(ItemStack stack) {
        this.stack = stack;
        this.style = TooltipDefinition.aggregateStyleFor(stack);
        this.label = TooltipLabel.findFor(stack);
        this.startTime = Util.m_137550_();
        this.particles = new ArrayList<ParticleData>();
    }

    public boolean isInitialFrame() {
        return Util.m_137550_() == this.startTime;
    }

    public float timeInSeconds() {
        return (float)(Util.m_137550_() - this.startTime) * 0.001f;
    }

    public ClientTooltipComponent createLabel() {
        return this.label != null ? this.label.create(this.stack) : BlankComponent.INSTANCE;
    }

    public void addParticle(ParticleData particle) {
        this.particles.add(particle);
    }

    public void maybePlayIconSound(SoundTemplate template) {
        if (!((Boolean)ClientConfig.SOUNDS_ENABLED.get()).booleanValue()) {
            return;
        }
        if (this.uuid.equals(lastIconSoundUuid)) {
            return;
        }
        if (Util.m_137550_() - this.startTime < 100L) {
            return;
        }
        if (Util.m_137550_() - lastIconSoundTime < 300L) {
            return;
        }
        lastIconSoundTime = Util.m_137550_();
        lastIconSoundUuid = this.uuid;
        template.play();
    }

    public void renderPanel(GuiGraphics graphics, Vector2ic pos, int width, int height) {
        if (this.style.panel().isEmpty()) {
            return;
        }
        this.style.panel().get().render(graphics, pos.x(), pos.y(), width, height);
    }

    public void renderEffects(GuiGraphics graphics, Vector2ic pos, int width, int height) {
        for (TooltipEffect effect : this.style.effects()) {
            graphics.m_286007_(() -> effect.renderBack(this, graphics, pos.x(), pos.y(), width, height));
        }
    }

    public void renderFrame(GuiGraphics graphics, Vector2ic pos, int width, int height) {
        if (this.style.frame().isEmpty()) {
            return;
        }
        this.style.frame().get().render(graphics, pos.x(), pos.y(), width, height);
    }

    public void update() {
        this.particles.removeIf(ParticleData::isExpired);
        this.isFirstFrame = false;
    }
}

