/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public class EntityAnimDataSyncPacket<D> {
    private final int entityId;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public EntityAnimDataSyncPacket(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        this.entityId = entityId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130070_(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> EntityAnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        int entityId = buffer.m_130242_();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.m_130277_());
        return new EntityAnimDataSyncPacket(entityId, dataTicket, dataTicket.decode(buffer));
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
            if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.setAnimData(this.dataTicket, this.data);
            }
        });
        handler.setPacketHandled(true);
    }
}

