/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.IHidden;
import com.aizistral.enigmaticlegacy.handlers.DevotedBelieversHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.packets.clients.PacketCosmicRevive;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class CosmicScroll
extends ItemBaseCurio
implements IHidden {
    private static final ResourceLocation ADVANCEMENT = new ResourceLocation("enigmaticlegacy", "main/cosmic_scroll");
    public static Omniconfig.PerhapsParameter unchosenDamageBonus;
    public static Omniconfig.PerhapsParameter unchosenKnockbackBonus;
    public static Omniconfig.PerhapsParameter etheriumShieldThreshold;
    public static Omniconfig.IntParameter deathProtectionCooldown;

    @SubscribeConfig
    public static void handleConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CosmicScroll");
        etheriumShieldThreshold = builder.comment("Alternative Etherium Shield health requirement for those who bear The Architect's Favor. Defined as percentage.").max(100.0).getPerhaps("EtheriumShieldThreshold", 80);
        unchosenDamageBonus = builder.comment("Attack damage bonus of The Architect's Favor against non-chosen players.").getPerhaps("UnchosenDamageBonus", 100);
        unchosenKnockbackBonus = builder.comment("Knockback bonus of The Architect's Favor against non-chosen players.").getPerhaps("UnchosenKnockbackBonus", 100);
        deathProtectionCooldown = builder.comment("Cooldown of death protection ability of The Architect's Favor. Measured in seconds.").getInt("DeathProtectionCooldown", 600);
        builder.popPrefix();
    }

    public CosmicScroll() {
        super(CosmicScroll.getDefaultProperties().m_41497_(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll4", ChatFormatting.GOLD, etheriumShieldThreshold + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll11", ChatFormatting.GOLD, deathProtectionCooldown);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll12", ChatFormatting.GOLD, unchosenDamageBonus + "%", unchosenKnockbackBonus + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll13");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScroll14");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScrollLore1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScrollLore2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (this.hasCooldown(stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cosmicScrollCooldown", ChatFormatting.GOLD, this.getCooldown(stack) / 20);
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateBlessedOnesOnly(list);
    }

    public boolean hasCooldown(ItemStack scroll) {
        return this.getCooldown(scroll) > 0;
    }

    public int getCooldown(ItemStack scroll) {
        if (scroll.m_150930_((Item)this)) {
            return ItemNBTHelper.getInt(scroll, "ReviveCooldown", 0);
        }
        return 0;
    }

    public void setCooldown(ItemStack scroll, int cooldown) {
        if (scroll.m_150930_((Item)this)) {
            ItemNBTHelper.setInt(scroll, "ReviveCooldown", cooldown);
        }
    }

    @Override
    public boolean canEquip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity;
        return super.canEquip(context, stack) && (livingEntity = context.entity()) instanceof Player && SuperpositionHandler.isTheBlessedOne(player = (Player)livingEntity);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("290d5f76-87aa-4f7c-9c1a-9aef2fe25d05"), "enigmaticlegacy:luck_bonus", 1.0, AttributeModifier.Operation.ADDITION));
        CuriosApi.getCuriosHelper().addSlotModifier((Multimap)attributes, "scroll", UUID.fromString("fb4dfa90-1df4-4e26-86a9-481dcdd830c5"), 1.0, AttributeModifier.Operation.ADDITION);
        return attributes;
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        if (!context.entity().m_9236_().f_46443_ && this.hasCooldown(stack)) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity pEntity, int pSlotId, boolean pIsSelected) {
        LivingEntity entity;
        ItemStack scrollStack;
        if (!level.f_46443_ && pEntity instanceof LivingEntity && stack != (scrollStack = SuperpositionHandler.getCurioStack(entity = (LivingEntity)pEntity, this)) && this.hasCooldown(stack)) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    @Override
    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        ServerPlayer player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer && DevotedBelieversHandler.isDevotedBeliever((Player)(player = (ServerPlayer)livingEntity)) && !SuperpositionHandler.hasAdvancement(player, ADVANCEMENT)) {
            SuperpositionHandler.grantAdvancement(player, ADVANCEMENT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().m_150930_((Item)this)) {
            if (EnigmaticLegacy.PROXY.getClientPlayer() != null && SuperpositionHandler.isTheBlessedOne(EnigmaticLegacy.PROXY.getClientPlayer())) {
                return;
            }
            List tooltip = event.getToolTip();
            for (int i = 0; i < tooltip.size(); ++i) {
                Component component = (Component)tooltip.get(i);
                String text = component.getString();
                tooltip.set(i, Component.m_237113_((String)SuperpositionHandler.obscureString(text)).m_6270_(component.m_7383_()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ItemStack scroll;
        Player player;
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().f_46443_ && SuperpositionHandler.isTheBlessedOne(player = (Player)event.getEntity()) && (scroll = SuperpositionHandler.getCurioStack((LivingEntity)player, this)) != null && !this.hasCooldown(scroll)) {
            event.setCanceled(true);
            player.m_21153_(player.m_21233_() / 2.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 1200, 2));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 1));
            this.setCooldown(scroll, deathProtectionCooldown.getValue() * 20);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 128.0, player.m_9236_().m_46472_())), (Object)new PacketCosmicRevive(player.m_19879_(), 0));
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (event.getAmount() >= Float.MAX_VALUE) {
            return;
        }
        if (event.getSource().m_7640_() instanceof Player && event.getSource().m_276093_(DamageTypes.f_268464_)) {
            Player player = (Player)event.getSource().m_7640_();
            float bonusDamage = 0.0f;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player victimPlayer = (Player)livingEntity;
                if (SuperpositionHandler.hasArchitectsFavor(player) && !SuperpositionHandler.isTheBlessedOne(victimPlayer)) {
                    bonusDamage += event.getAmount() * unchosenDamageBonus.getValue().asModifier(false);
                    event.getEntity().m_20254_(4);
                }
            }
            event.setAmount(event.getAmount() + bonusDamage);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && SuperpositionHandler.isTheBlessedOne((Player)(player = (ServerPlayer)player2)) && !SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "book/accessories/cosmic_scroll_obscure"))) {
            SuperpositionHandler.grantAdvancement(player, new ResourceLocation("enigmaticlegacy", "book/accessories/cosmic_scroll_obscure"));
        }
    }
}

