/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.integration.jei;

import com.teamabnormals.woodworks.common.item.crafting.SawmillRecipe;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import com.teamabnormals.woodworks.integration.jei.WoodworksPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class SawingRecipeCategory
implements IRecipeCategory<SawmillRecipe> {
    public static final String TRANSLATION = "gui.woodworks.category.sawmill";
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public SawingRecipeCategory(IGuiHelper guiHelper) {
        this(guiHelper, TRANSLATION, 82, 34);
    }

    public SawingRecipeCategory(IGuiHelper guiHelper, String translationKey, int width, int height) {
        this.background = guiHelper.createBlankDrawable(width, height);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)WoodworksBlocks.SAWMILL.get()));
        this.localizedName = Component.m_237115_((String)translationKey);
    }

    public RecipeType<SawmillRecipe> getRecipeType() {
        return WoodworksPlugin.SAWING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SawmillRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 9).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addOutputSlot(61, 9).setOutputSlotBackground().addItemStack(SawingRecipeCategory.getResultItem(recipe));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, SawmillRecipe recipe, IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(26, 9);
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }

    public boolean isHandled(SawmillRecipe recipe) {
        return true;
    }
}

