/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.network;

import net.mindoth.shadowizardlib.network.PacketSendCustomParticles;
import net.mindoth.shadowizardlib.network.PacketSyncClientEffects;
import net.mindoth.shadowizardlib.network.PacketToggleClientEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ShadowNetwork {
    private static SimpleChannel CHANNEL;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void init() {
        SimpleChannel net;
        CHANNEL = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("shadowizardlib", "network")).networkProtocolVersion(() -> "3.0.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(PacketSyncClientEffects.class, ShadowNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PacketSyncClientEffects::new).encoder(PacketSyncClientEffects::encode).consumerMainThread(PacketSyncClientEffects::handle).add();
        net.messageBuilder(PacketToggleClientEffects.class, ShadowNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PacketToggleClientEffects::new).encoder(PacketToggleClientEffects::encode).consumerMainThread(PacketToggleClientEffects::handle).add();
        net.messageBuilder(PacketSendCustomParticles.class, ShadowNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PacketSendCustomParticles::new).encoder(PacketSendCustomParticles::encode).consumerMainThread(PacketSendCustomParticles::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        CHANNEL.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        if (player != null) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
        }
    }

    public static <MSG> void sendToPlayersTrackingEntity(MSG message, Entity entity) {
        if (entity != null) {
            ShadowNetwork.sendToPlayersTrackingEntity(message, entity, false);
        }
    }

    public static <MSG> void sendToPlayersTrackingEntity(MSG message, Entity entity, boolean sendToSource) {
        if (entity != null) {
            CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
            if (sendToSource && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ShadowNetwork.sendToPlayer(message, serverPlayer);
            }
        }
    }

    public static <MSG> void sendToNearby(MSG message, Level world, Entity caster) {
        ShadowNetwork.sendToNearby(message, world, caster.m_20183_());
    }

    public static <MSG> void sendToNearby(MSG message, Level level, Vec3 center) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos(Mth.m_14107_((double)center.f_82479_), Mth.m_14107_((double)center.f_82480_), Mth.m_14107_((double)center.f_82481_));
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 4096.0).forEach(p -> ShadowNetwork.sendToPlayer(message, p));
        }
    }

    public static <MSG> void sendToNearby(MSG message, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 4096.0).forEach(p -> ShadowNetwork.sendToPlayer(message, p));
        }
    }

    public static <MSG> void sendToAll(MSG message) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), message);
    }

    static {
        packetId = 0;
    }
}

